
#error  _JEffectValueController_H
#ifndef _JEffectValueController_H
#define _JEffectValueController_H

#include "JValueController.h"
#include "JEffect.h"

/// Concrete ValueController that plugs the setValue into a JEffect.

class JEffectValueController:public JValueController
{
  public:
    ///
    JEffectValueController(JEffect *effect);
    
    ///
    int minValue() const;
    ///
    int maxValue() const;
    ///
    int value()    const;

    ///
    const char *name() const { return _effect->name(); }
    ///
    void setValue(int value,JVoice &);

  protected:
    ///
    JEffect  *       _effect;
};




#endif



