#include <iostream.h>
#include "JConductor.h"
#include "JScheduler.h"
#include "jam/JTrack.h"
#include "jam/JFlags.h"
#include "jam/JSequence.h"
#include "seq/JSequencer.h"
#include "JTimer.h"
#include "JScheduler.h"
#include "jam/JFocus.h"
#include "jam/JError.h"
#include "seq/JSeqAlloc.h"



#ifdef DEBUG
#include <iostream.h>
#define DEBUGOUT(x) cout << x;
#else
#define DEBUGOUT(x)
#endif

JConductor::JConductor(JSequence *seq)
  :
  _left(JBeat(0)),
  _right(JBeat(4)),
  _start(JBeat::startOfTime()),
  _end(JBeat::endOfTime()),
  _nowBeat(0),
  _retBeat(0),
  _loop(false),
  _defaultSequence(seq),
  _mySequencer(0),
  _timer(JTimer::the()),
  _scheduler(JScheduler::the()),
  _lock(false),
  _beatAfterEnd(JBeat::startOfTime())

{

  // 1Mbyte of memory for the sequencers to graze on.
  JSeqAlloc::init(1000000);

}


void  
JConductor::setLeft(JBeat left)
{
  if (left < JBeat(0)) left=JBeat(0);
  _left=left;
  if (_right < _left)
    _right = _left;
}

void  
JConductor::setRight(JBeat right)
{
  if (right < JBeat(0)) right=JBeat(0);
  _right=right;
  if (_right < _left )
      _left = _right;
}

bool
JConductor::isPlaying() const
{
  return (!_timer->isStoped());
}

void
JConductor::stop(bool purgeSeq)
{
  _timer->stop();
  _scheduler->setAlarmClient(0);
  

  notifyObservers(JPlayerCommand::SILENT);

  if (purgeSeq) {
    delete _mySequencer;  
    JSeqAlloc::free();
  }

  _mySequencer=0;
}


void
JConductor::setCurrentBeat(JBeat beat)
{
  if (beat < JBeat(0)) beat=JBeat(0);

  bool isPlaying = !_timer->isStoped();

  if (isPlaying) {
    stop(true);
    _mySequencer = _defaultSequence->createSequencer(0);
    _nowBeat=beat;
    _timer->setNow(_nowBeat);
    start();
  } else {
    _nowBeat=beat;
    _timer->setNow(_nowBeat);
  }
}


void
JConductor::setLooping(bool on)
{
  _loop = on;
}
 
void
JConductor::start()
{

#ifdef DEBUG
  cout << "JConductor:START" << endl;
#endif

  assert(_mySequencer != 0 );
  assert(_timer->isStoped());
  _beatAfterEnd = _nowBeat;
  _nextBeat = _mySequencer->gotoBeat(_nowBeat);

#ifdef DEBUG
  cout << "JConductor:next beat" << _nextBeat <<endl;
#endif

  if (_nextBeat <= _end) {

    _timer->setNow(_nowBeat);
    _scheduler->setAlarmAt(_nextBeat);
    _scheduler->setAlarmClient(this);
    _timer->start();

  }
}

JConductor::~JConductor()
{
  if (_mySequencer != 0) {
    delete _mySequencer;
    JSeqAlloc::free();
  }
  _scheduler->setAlarmClient(0);
  _timer->stop();
}


void
JConductor::interuptHandler(int)
{

#ifdef DEBUG
   cout << "JConductor interupt handler" << endl;
#endif

  assert(_mySequencer != 0);

  if (!_timer->isStoped()) {


    if (_loop) {
      if (_nowBeat > _right) {
	if (_left < _right) {
	  setCurrentBeat(_left);
	  return;
	}
      }
    }

    _nowBeat=_nextBeat;
    _nextBeat=_mySequencer->execute();

    if (_loop) {
      if (_nextBeat > _right) {
	if (_left < _right) {
	  _nextBeat = _right+JDuration(0,1,720);
	}
      }
    }

    if (_nextBeat == JBeat::endOfTime()) {
      stop(true);
      setCurrentBeat(_retBeat);
      return;
    }
  } else {
    stop(true);
    return;
  }

  if ( _nextBeat <= _end ) {
    _scheduler->setAlarmAt(_nextBeat);
  } else {
    stop(true);
    setCurrentBeat(_retBeat);

  }

}


void
JConductor::handle(JConductorCommand command)
{


  switch(command.type()) {
    
  case JConductorCommand::START:
    stop(true);
    _mySequencer=_defaultSequence->createSequencer(0);
    start();
    _lock=true;
    break;
    
  case JConductorCommand::REWIND:
    _nowBeat=_start;
    _retBeat=_start;
    _timer->setNow(_nowBeat);
    
  case JConductorCommand::STOP:
    stop(true);
    break;
    
  default:
    break;
  }
}



void
JConductor::handle(JSequencer *sequencer)
{

  if (!_timer->isStoped()) 
    if (_lock) return;

  
  stop(false);

  _mySequencer = sequencer;
  _nowBeat=sequencer->nextBeat();
  _retBeat=_nowBeat;

#ifdef DEBUG
  cout << " NOWBEAT" << _nowBeat << endl;
#endif
 
  start();
  _lock = false;

}









