#include <iostream.h>
#include <string.h>

#include "JComposition.h"
#include "JVoiceManager.h"
#include "JTrackList.h"
#include "seq/JMetaSequencer.h"
#include "JMeter.h"
#include "JVoice.h"
#include "JMapper.h"
#include "JToolBox.h"
#include "rep/JReader.h"

JComposition::JComposition(const char *name)
  :JName(name),
   _meter(new JMeter())
{
  //  assert(_the==0);
  //_the=this;

}

JComposition::~JComposition()
{
  // Delete all my tracks
 _trackList.clear(true);
}

JTrack *
JComposition::newTrack(JVoice *voice,const char *name)
{

  if ( name == 0 ) { 
    if (voice != 0) {
      name = voice->name();
    } else {
      name = "NONAME";
    }
  } else {
    name = "NONAME";
  }
  
  JTrack *track=new JTrack(voice,this,name);
  _trackList.add(track);
  return track;
}

JSequencer *
JComposition::createSequencer(JPlayer *player) const
{
  JTrackListIterator iter(&_trackList);
  return new JMetaSequencer(iter,player);
}


bool
JComposition::write(ostream &out) const
{
  out << "$Composition " << endl;
  out <<  name() << endl;
  
  JTrackListIterator iter(trackList());

  JTrack *track;

  while( (track=iter.next()) != 0) {
    JVoice *voice=track->player()->voice();
    assert(voice != 0);
    out << "$Voice " 
        << voice->name() << " " 
	<< voice->defaultDeviceName() << " "
	<< voice->channelId() << " "
	<< voice->bankId() << " "
	<< voice->programId() << endl;
    track->write(out);
  }
  out << "$End" << endl;

  return out.fail();
}


bool
JComposition::read(JReader &in)
{
  char buff[132];
  char voiceName[132];
  char devName[132];
  JToken tok;
  int i;
  JVoice *voice=0;

  if ( !in.getToken(tok) ) return false;

  if ( tok != T_Composition) {
    JToolBox::the()->query("Oooops magic not there","");
    return false;
  }

  in.getString(buff,60);
  rename(buff);

  if (in.fail()) return false;  

  JTrack *track=0;

  while(in.getToken(tok)) {
    
    switch(tok) {
    case T_Voice:

      in.getString(voiceName,132);
      in.getString(devName,132);
      voice = JVoiceManager::the()->newVoice(devName);
      voice->rename(voiceName);

      in.getInt(i);
      voice->setChannelId(i);

      in.getInt(i);
      voice->setBankId(i);

      in.getInt(i);
      voice->setProgramId(i);
      break;

    case T_Track:
      track = newTrack(voice,voiceName);
      if (track->read(in)) break;
      return false;

    case T_End:
      return true;


    default:
      cout << __FILE__ << __LINE__ << " unexpected " << in.last() << endl;
      return false;
    }
  }

  return false;
}





