#ifndef _rcorblk_H
#define _rcorblk_H

// This file is an object called rhythm correlation block //
// 16 dec 1997 Julian Sweeting //

class beat_block_c;

class rhythm_corr_block_c{
	 friend class rhythm_correlate_c;
  public:
	 rhythm_corr_block_c();
	 rhythm_corr_block_c(int corr_weight_i, int group_i, int *fraction_array_p,
							 int no_matches_i, int no_main_gaps_i, int no_comp_gaps_i);
	 rhythm_corr_block_c *change_linkR(rhythm_corr_block_c *linkR_p);
	 rhythm_corr_block_c *change_linkL(rhythm_corr_block_c *linkL_p);
	 int group(){return group_int;}
	 int weight(){return corr_weight_int;}
	 int main_matches(){return no_matches_int;}
	 int main_gaps(){return no_main_gaps_int;}
	 int comp_gaps(){return no_comp_gaps_int;}
	 beat_block_c *total_shift(){return total_shift_ptr;}
	 beat_block_c *main_match_array(){return main_match_array_ptr;}
	 beat_block_c *main_gap_array(){return main_gap_array_ptr;}
	 beat_block_c *comp_gap_array(){return comp_gap_array_ptr;}
	 rhythm_corr_block_c *Rlink(){return linkR_ptr;}
	 rhythm_corr_block_c *Llink(){return linkL_ptr;}
  private:
	 rhythm_corr_block_c *linkR_ptr;
	 rhythm_corr_block_c *linkL_ptr;
	 int corr_weight_int;
	 int no_matches_int;
	 int no_main_gaps_int;
	 int no_comp_gaps_int;
	 int group_int;
	 beat_block_c *total_shift_ptr;
	 beat_block_c *main_match_array_ptr;
	 beat_block_c *main_gap_array_ptr;
	 beat_block_c *comp_gap_array_ptr;
};

#endif
