#ifndef _phrase_c_h
#define _phrase_c_h

// This file is an object called phrase //
// 16 dec 1997 Julian Sweeting //

class note_c;
class rhythm_block_c;
class block_iterator_c;
class note_block_c;
class beat_block_c;

class phrase_c{
  public:
	 phrase_c();
  phrase_c(double tempo_d, int beats_inbar_i, int beat_type_i, int beat_i,
	   int numerator_i, int denominator_i, int note_i, double length_d,
	   int velocity_i);

  void remove_all();

    void update_phrase_info();
	 double change_tempo(double phrase_tempo_d);
	 int add_note(int beat_i, int numerator_i, int denominator_i, int note_i,
						double length_d, int velocity_i);
	 int add_note(int *fraction_array_p, note_c *note_p);
	 note_c *remove_note(int *fraction_array_p, int note_i, int leave_note_i);
	 note_c *remove_note(int leave_note_i);
	 void swap_notes(int beat_i, int numerator_i, int denominator_i, int note_i,
						  int beat2_i, int numerator2_i, int denominator2_i,
						  int note2_i);
	 /*
	 void swap_notes(note_c *note_p, note_c *note2_p);
	 */
	 void shift_note(int *fraction_array_p, int note_i, int shift_num_i,
						  int shift_denom_i);
	 int shift_note(int shift_num_i, int shift_denom_i);
	 void shift_note(int *fraction_array_p, int note_i, int *fraction2_array_p);
	 int compare_fractions(int *fraction_array_p);
	 int compare_fractions(int *fraction_array_p, int *fraction_array2_p);
	 void add_fractions(int *fraction_array_p, int *fraction_array2_p,
	                    int *fraction_array3_p, int subtract_i);
	 void minimise_fraction(int *fraction_array_p);
	 int find_rhythm_block(int *fraction_array_p);
	 void display_current_note();
	 void display_phrase();
	 int average_pitch(){return average_pitch_int;}
	 int average_velocity(){return average_velocity_int;}
	 int highnote(){return high_note_int;}
	 int lownote(){return low_note_int;}
	 int fraction(){return smallest_fraction_int;}
	 int no_beat_blocks(){return no_beat_blocks_int;}
	 int beats_in_bar(){return beats_inbar_int;}
	 int beat_type(){return beat_type_int;}
	 double tempo(){return tempo_dbl;}
	 rhythm_block_c *phrase(){return start_ptr;}
	 block_iterator_c *iterator(){return iterator_ptr;}
  private:
	 void swap_notes();

	 // Checks for a rhythm block of beat A and sets current rhythm block if //
	 // found //
	 int find_note_block(int note_i);
	 // Combibes rhythm and note block finds, 0 none, 1 rhythm blk, 2 note blk //
	 int find_note(int *fraction_array_p, int note_i);
	 note_block_c *change_left_nb_pntr(note_block_c *note_block_p);
	 note_block_c *change_right_nb_pntr(note_block_c *note_block_p);
	 rhythm_block_c *change_left_rb_pntr(rhythm_block_c *rhythm_block_p);
	 rhythm_block_c *change_right_rb_pntr(rhythm_block_c *rhythm_block_p);
	 void create_note_block(note_c *note_p);
	 void create_rhythm_block(int *fraction_array_p, note_c *note_p);
	 void create_start_rhythm_block(int *fraction_array_p, note_c *note_p);
	 void delete_note_block(int leave_note_i);
	 void delete_rhythm_block(int leave_note_i);
	 int find_rhythm_block_entry(int *fraction_array_p);

	 // Private member variables //
	 int average_pitch_int;
	 int average_velocity_int;
	 int high_note_int;
	 int low_note_int;
	 block_iterator_c *iterator_ptr;
	 int smallest_fraction_int;
	 int no_beat_blocks_int;
	 double tempo_dbl;
	 int beats_inbar_int;
	 int beat_type_int;
	 rhythm_block_c *start_ptr;
};


#endif
