/* PJL adapted code. Pinched from
 *
 * Author:		Giovanni Pezzino
 * Purpose:		A collection of generic go features for TEAMGO.
 * History:		Created by GioVAX, adapted by Bruce Cropley 28/10/95
 */

#include 		"assert.h"
#include		"JList.h"

JListBase::JListBase( int clusSize )
: _things( 0 ),
  _next( 0 ),
  _numElems( 0 ),
  _clusterSize( clusSize ) 
{
  assert(clusSize > 0);

  _things = new void *[_clusterSize];
  
  assert(_things != 0);
  
  for( int i = 0; i < _clusterSize; i++ )
    _things[i] = 0;
}

JListBase::~JListBase() 
{
    clear();
    delete [] _things;
}

bool JListBase::add(void *fea, const bool check ) 
{
    // returns TRUE if the element wasn't previously contained in the list.
    // returns FALSE if the element was already present.
    // in any case, at the end, the element is contained in the list.
    
    
    if( check )
      if ( contains( fea )) return false;
    
    if( _numElems < _clusterSize ) 
    {
	_things[_numElems++] = fea;
	return true;
    }
    else 
    {
	if( !_next )
	{
	    _next = new JListBase( _clusterSize );
	    assert(_next != 0);
	}
	return _next->add( fea, false );
    }
    
}


bool
JListBase::remove( const void *fea ) 
{
    // returns TRUE if the element was previously contained in the list.
    // returns FALSE if the element wasn't already present.
    // in any case, at the end, the element is not contained in the list.
    
    for( int i = 0; i < _numElems; i++ )
      if( fea == _things[i] ) 
      {
	  _things[i] = _things[--_numElems];
	  return true;
      }
    
    if( _next )
      return _next->remove( fea );
    else
      return false;
}


void 
JListBase::clear() 
{
    
    if( _next )
      delete _next;
    
    _next = 0;
    _numElems = 0;
}

bool 
JListBase::contains( const void *fea ) const 
{
    
    for( int i = 0; i < _numElems; i++ )
      if( fea == _things[i] )
	return true;
    
    if( _next )
      return _next->contains( fea );
    else
      return false;
}

int 
JListBase::count() const 
{
    
    if( _next )
      return _numElems + _next->count();
    else
      return _numElems;
}

void * 
JListBase::first() const
{
    if (_numElems > 0) {
	return _things[0];
    } else if (_next != 0) {
	return (_next->first());
    } else
      return 0;
}

void * 
JListBase::at(int index) const
{
    assert(index >= 0);
    
    if (_numElems > index) 
    {
	return _things[index];
    } 
    else if (_next != 0) 
    {
	return (_next->at(index-_numElems));
    } 
    else
      return 0;
}



void *
JListBaseIterator::thingPtr() const 
{
    
    if( !_list || _index >= _list->_numElems )
      return 0;
    
    return _list->_things[_index];
}

void 
JListBaseIterator::increment() 
{
    
    if( ++_index >= _list->_numElems ) 
    {
	_list = _list->_next;
	_index = 0;
    }
}

void  *
JListBaseIterator::next()
{
    if ( _list && ( _index < _list->_numElems)  )
    {
	void *f = thingPtr();
	increment();
	return f;
    }
    else
      return 0;
}


#if 0
JListBaseIterator::operator int() const 
{
    return _list && _index < _list->_numElems;
}


void 
JListBaseIterator::reset( const JListBase *newList ) 
{
    
    if( !_head )
      _head = newList;
    
    _index = 0;
    
    if( newList )
      _list = newList;
    else
      _list = _head;
}



#endif


