#include <iostream.h>
#include <ctype.h> // toupper()

#include "QJPhraseEditor.h"
#include "rep/JBeat.h"
#include "jam/JDurationTool.h"
#include "jam/JVelocityTool.h"
#include "rep/JBeat.h"
#include "jam/JPhrase.h"
#include "jam/JPhraseController.h"
#include "jam/JNoteGesture.h"
#include "jam/JEffectEventGesture.h"
#include "jam/JFocus.h"
#include "jam/JConductor.h"
#include "jam/JCursor.h"
#include "jam/JContext.h"
#include "jam/JVoice.h"
#include "jam/JTrack.h"
#include "jam/JPart.h"

QJPhraseEditor::QJPhraseEditor(JContext *context)
  :_phrase(0),
   _context(context),
   _iTweak(1),
   _onCount(0)
{

}


QJPhraseEditor::~QJPhraseEditor()
{

}


QJEditor::State
QJPhraseEditor::setContext()
{


  JPhrase *phrase=_context->focus()->phrase();
  
  if (phrase == 0) {
    _phrase = 0;
    return NoSubject;
  }

  if ( _phrase != phrase) {
    _phrase = phrase;
    if (_phrase->controller() == 0); 
    _phrase->setController(new JPhraseController(_phrase));
  }

  return OK;
}

#if 0
void
QJPartEditor::insert()
{
  JTrack * track  = _context->focus()->track();
  if (track == 0) return;
  
  JPart *part=track->newPart();
  _context->focus->setPart(part);

}
#endif

void
QJPhraseEditor::update()
{

  setContext();

  if (_phrase != 0)  {
    if (_phrase->controller()->focus() != 0 ) {
      //      debug(" Hello !!!! ");
      _context->cursor()->setBeat(_phrase->controller()->focus()->start());
      _context->cursor()->hide();
    } else {
      _context->cursor()->show();
    }
    _phrase->update();
  } 
  _context->cursor()->update();
}

/*!
  attached then detach.
  detached then focus->phrase!=0 then set focus->phrase=0


 */

void
QJPhraseEditor::escape()
{
  if ( setContext() != OK ) return ;
  if (_phrase->controller()->focus() != 0) {
    _context->cursor()->setBeat(_phrase->controller()->focus()->start());
    _phrase->controller()->detachFocus();
  } else {
    _context->focus()->setPhrase(0);
  }
  update();
}

void
QJPhraseEditor::right()
{
  if ( setContext() == NoSubject ) {

    _context->cursor()->moveRightBy(*_context->duration());

  } else if (setContext() == OK) {
  
    if (_phrase->controller()->focus() == 0) {
      _context->cursor()->moveRightBy(*_context->duration());
    } else {
      
      const JGesture *event=_phrase->controller()->moveFocusRight();
      
      if (event == 0) {
	_context->cursor()->moveRightBy(*_context->duration());
      } else {
	playFocus();
      }
    }

  }
  update();
}

void
QJPhraseEditor::left()
{
  if ( setContext() == NoSubject ) {

    _context->cursor()->moveLeftBy(*_context->duration());

  } else if (setContext() == OK) {

    if (_phrase->controller()->focus() == 0) {
      _context->cursor()->moveLeftBy(*_context->duration());
    } else {
      const JGesture *event=_phrase->controller()->moveFocusLeft();
      
      if (event == 0) {
	_context->cursor()->moveLeftBy(*_context->duration());
      } else {
	playFocus();
      }
    }

  }

  update();
}

void 
QJPhraseEditor::metaup()
{
  _context->focus()->nextPhrase();
  update();
}


void 
QJPhraseEditor::metadown()
{
  _context->focus()->prevPhrase();
  update();
}

void 
QJPhraseEditor::metainsert()
{
    
  setContext();

  JTrack * track  = _context->focus()->track();
  if ( track == 0 ) return;
  JPart *  part   = _context->focus()->part();

  JPhrase *  phrase = track->newPhrase(part);
  
  _context->focus()->setPhrase(phrase);

  if ( setContext() != OK ) {
    assert(0);
  }
  
}


void 
QJPhraseEditor::handle(JMidiOutEvent e)
{
  if (_phrase == 0) {
    metainsert();
  }


  JGesture *g=0;
  switch (e.type() ) {
  case JMidiOutType::NOTE_EFFECT:
    if (e.value() == 0) {
      _onCount--;
      if (_onCount == 0) {
	_context->cursor()->moveRightBy(*_context->duration());
      } else {
	assert(_onCount > 0);
      }
    } else {
      g = new JNoteGesture(_context->cursor()->beat(),
			   *_context->duration(),
			   e.index(),
			   120);
      _onCount++;
    }
    break;
    
  default:

    // TODO purge redundant events.
    g = new JEffectEventGesture(_context->cursor()->beat(),
			       e);
    break;

  }

  if (g != 0 ){
    assert(_phrase->controller() != 0);
    _phrase->controller()->insertGesture(g);
    _context->conductor()->setCurrentBeat(g->start());
    //    _context->cursor()->setPitch(phrase->controller()->setFocus(g);
  }

  update();
}


void
QJPhraseEditor::insert()
{
 
  if ( setContext() == NoSubject ) {
    metainsert();
    if (_phrase == 0) return;
  }

  JGesture * gesture = 0;

  if ( setContext() != OK ) return;

  if (_phrase->controller()->focus() == 0) {

    gesture = new JNoteGesture(_context->cursor()->beat(),
			       *_context->duration(),
			       _context->cursor()->pitch(),
			       120);

    _phrase->controller()->insertGesture(gesture);
    playGesture(gesture);
    _context->cursor()->setBeat(_context->cursor()->beat() + *_context->duration());

  } else {

    _phrase->controller()->shiftRightOfBy(*_context->duration());

    gesture = new JNoteGesture( _context->cursor()->beat(),
				*_context->duration(),
				_context->cursor()->pitch(),
				120);
					 
    _phrase->controller()->insertGesture(gesture);
    playGesture(gesture);
  }

  update();
}

void
QJPhraseEditor::enter()
{
  if (setContext() != OK) return;

  cout << _context->cursor()->beat() << endl;

  _phrase->controller()->attachFocusAt(_context->cursor()->beat());

  playFocus();

  update();
}


void
QJPhraseEditor::space()
{
  if (setContext() != OK ) {
    right();
  } else if (_phrase->controller()->focus() == 0) {
    right();
  } else {
    _phrase->controller()->shiftRightOfBy(*_context->duration());
  }

  update();
}


void
QJPhraseEditor::backspace()
{
  if (setContext() != OK ) {
    left();
  } else if (_phrase->controller()->focus() == 0) {
    left();
  } else {
    _phrase->controller()->shiftRightOfBy(-*_context->duration());
  }

  update();
}

void 
QJPhraseEditor::del()
{
  if (setContext() != OK ) return;

  _phrase->controller()->deleteFocus();

  update();
}

void
QJPhraseEditor::up()
{

  //  debug("QJPhraseEditor::shiftup()");

  setContext();

  JGesture *event = 0;

  if (_phrase != 0 ) event=_phrase->controller()->focus();

  if (event == 0) {
    _context->cursor()->incPitch();      
    //    if (_controller != 0) _controller->detachFocus();
  } else {
    event->tweak(1.0);
    _phrase->controller()->updateFocus();
    playFocus();
  }

  update();
}

void
QJPhraseEditor::down()
{

  setContext();

  JGesture *event = 0;

  if (_phrase != 0 ) event=_phrase->controller()->focus();

  if (event == 0) {
    _context->cursor()->decPitch();
    //    if (_controller != 0) _controller->detachFocus();
  } else {
    event->tweak(-1.0);
    _phrase->controller()->updateFocus();
    playFocus();
  }

  update();
}

void 
QJPhraseEditor::playFocus()
{

  if (setContext() != OK ) return;

  JGesture  * g=_phrase->controller()->focus();
  if ( g != 0 ) {
    // cout << g->typeName() << endl;
    _context->conductor()->handle(g->createSequencer(_phrase->player()));    
    //cout << " Done " << endl;
  }
}
    

void 
QJPhraseEditor::playGesture(JGesture *g)
{

  if (setContext() != OK ) return;

  if ( g != 0 ) {
    //    cout << g->typeName() << endl;
    _context->conductor()->handle(g->createSequencer(_phrase->player()));    
    // cout << " Done " << endl;
  }
}
    



void
QJPhraseEditor::keyPress(QKeyEvent *e)
{

  cout << " EDITOR ASCII EVENT  >" << 
    (char)e->ascii() << "<" << endl;

  if (setContext() != OK ) return;

  JGesture *g=_phrase->controller()->focus();
  if (g == 0 ) return;

  switch(e->ascii()) {
  case 'E':
    assert(0);
    cout << "Built effect list" << endl;
    break;
    
  case '+':
    g->tweak(1.0,_iTweak);
    _phrase->controller()->updateFocus();
    playFocus();
    break;

  case ']':
    g->tweak(10.0,_iTweak);
    _phrase->controller()->updateFocus();
    playFocus();
    break;

  case '[':
    g->tweak(-10.0,_iTweak);
    _phrase->controller()->updateFocus();
    playFocus();
    break;
      
      
  case '-':
    g->tweak(-1.0,_iTweak);
    _phrase->controller()->updateFocus();
    playFocus();
    break;
    
    
  default:

    if (isdigit(e->ascii())) {
      _iTweak = e->ascii() - '0';
    }

    
    break;
  }

  cout << " DEBUG 2 " <<  endl;

  update();
}












