#ifndef _QJCompositionView_H
#define _QJCompositionView_H

#include <qlistview.h>

class JComposition;
class QPopupMenu;
class JContext;
class JTrack;
class QJTrackItem;

class QJCompositionView: public QListView
{
  Q_OBJECT
public:
  QJCompositionView(QWidget *parent, JContext  * );
  ~QJCompositionView();
  const char * text( int column ) const;
  void setSelected(QListViewItem *it,bool flag);
  //  void popup();
 public  slots:
  // cause a new track to be created
  void  newTrack();
  // clones the focus track
  void  cloneTrack();
  // deletes a selected track
  void  deleteTrack();

  // cause a complete rebuild.
  void  rebuild();

  void  selectionChange(QListViewItem *it);
  void  rightButtonPressedSlot(QListViewItem *, const QPoint &, int );

  void  mouseMoveEvent(QMouseEvent *e);
  void  keyPressEvent(QKeyEvent *e);
  

protected:
  void  mousePressEvent(QMouseEvent *e);
  void  mouseReleaseEvent(QMouseEvent *e);

private:
  JComposition * _comp;
  QPopupMenu *   _popup;
  JContext *     _context;			 
  JTrack  *      _selectedTrack;
  QJTrackItem *  _trackItem;
  int            _colSelected;
  QPoint         _anchor;
  bool           _editPress;
};


#endif
