/*================================================================
 * awe_effect.h
 *	convert NRPM parameters to Emu8000 raw effects
 *================================================================*/

#include <stdio.h>
#include <math.h>
#include "util.h"
#include "awe_effect.h"
#ifdef linux
#include <linux/awe_voice.h>
#else
#include <awe_voice.h>
#endif

unsigned short fx_delay(int val)
{
	return (0x8000 - val * 4 * 1000 / 725);
}

unsigned short fx_attack(int val)
{
	unsigned short ret;
	if (val == 0)
		return 0x7f;
	else if (val >= 360)
		ret = (unsigned short)(11878 / val);
	else if (val < 360)
		ret = (unsigned short)(32 + 53.426 * log10(360.0/val));
	else
		return 0x7f;
	if (ret < 1) ret = 1;
	return ret;
}

unsigned short fx_hold(int val)
{
	return 0x7f - (unsigned char)(val / 92);
}

unsigned short fx_decay(int val)
{
	unsigned short ret;
	if (val == 0)
		return 0x7f;
	else
		ret = (unsigned short)(0x7f - 42 * log10(val * 4 / 23.04));
	if (ret < 1) ret = 1;
	if (ret > 0x7f) ret = 0x7f;
	return ret;
}

unsigned short fx_the_value(int val)
{
	return (unsigned short)(val & 0xff);
}

unsigned short fx_twice_value(int val)
{
	return (unsigned short)((val * 2) & 0xff);
}

unsigned short fx_conv_pitch(int val)
{
	return (short)(val * 4096 / 1200);
}

unsigned short fx_conv_Q(int val)
{
	return (unsigned short)((val / 8) & 0xff);
}


struct awe_effect_rec awe_effects[] =
{
	{AWE_FX_ENV1_DELAY,	fx_env1_delay,	"e1_delay"},
	{AWE_FX_ENV1_ATTACK,	fx_env1_attack,	"e1_attack"},
	{AWE_FX_ENV1_HOLD,	fx_env1_hold,	"e1_hold",},
	{AWE_FX_ENV1_DECAY,	fx_env1_decay,	"e1_decay"},
	{AWE_FX_ENV1_RELEASE,	fx_env1_release,"e1_release"},
	{AWE_FX_ENV1_SUSTAIN,	fx_env1_sustain,"e1_sustain"},
	{AWE_FX_ENV1_PITCH,	fx_env1_pitch,	"e1_pitch"},
	{AWE_FX_ENV1_CUTOFF,	fx_env1_cutoff,	"e1_cutoff"},

	{AWE_FX_ENV2_DELAY,	fx_env2_delay,	"e2_delay"},
	{AWE_FX_ENV2_ATTACK,	fx_env2_attack,	"e2_attack"},
	{AWE_FX_ENV2_HOLD,	fx_env2_hold,	"e2_hold"},
	{AWE_FX_ENV2_DECAY,	fx_env2_decay,	"e2_decay"},
	{AWE_FX_ENV2_RELEASE,	fx_env2_release,"e2_release"},
	{AWE_FX_ENV2_SUSTAIN,	fx_env2_sustain,"e2_sustain"},

	{AWE_FX_LFO1_DELAY,	fx_lfo1_delay,	"L1_delay"},
	{AWE_FX_LFO1_FREQ,	fx_lfo1_freq,	"L1_freq"},
	{AWE_FX_LFO1_VOLUME,	fx_lfo1_volume,	"L1_volume"},
	{AWE_FX_LFO1_PITCH,	fx_lfo1_pitch,	"L1_pitch"},
	{AWE_FX_LFO1_CUTOFF,	fx_lfo1_cutoff,	"L1_cutoff"},

	{AWE_FX_LFO2_DELAY,	fx_lfo2_delay,	"L2_delay"},
	{AWE_FX_LFO2_FREQ,	fx_lfo2_freq,	"L2_freq"},
	{AWE_FX_LFO2_PITCH,	fx_lfo2_pitch,	"L2_pitch"},

	{AWE_FX_INIT_PITCH,	fx_init_pitch,	"init_pitch"},
	{AWE_FX_CHORUS,		fx_chorus,	"chorus"},
	{AWE_FX_REVERB,		fx_reverb,	"reverb"},
	{AWE_FX_CUTOFF,		fx_cutoff,	"cutoff"},
	{AWE_FX_FILTERQ,	fx_filterQ,	"filterQ"},
};

int num_awe_effects = numberof(awe_effects);


