#include "JPhraseController.h"
#include "JPhraseNotator.h"
#include "JGestureList.h"
#include "JPhrase.h"
#include "JScorePainter.h"

JPhraseNotator::JPhraseNotator(JScorePainter *p,const JPhrase *phrase)
  :_scorePainter(p),
   _phrase(phrase)
{}



void 
JPhraseNotator::update(JLRRep lr,JStyle style)
{

  if (_phrase == 0) return;
  JGestureListIterator iter(_phrase->gestureList());
  

  const JGesture *hiGesture=0;

  JBeat left = lr.left();

  if (style == NORMAL) {
     if (_phrase->controller() != 0 )
       hiGesture = _phrase->controller()->focus();
  }

  JGesture *gesture;

  while( (gesture = iter.next()) != 0) {

    if (gesture->end() < left ) continue;

    if (gesture->start() > left) {
      _scorePainter->drawRest(left,gesture->start()-left);
    }

    if (left < gesture->end()) {
	left=gesture->end();
    }

    
    JNotator *p=gesture->createNotator(_scorePainter);

    if ( gesture == hiGesture) {
      p->update(gesture->lrRep(),HILIGHT);
    } else {
      p->update(gesture->lrRep(),style);
    }

    delete p;

    if (gesture->start() > lr.right()) break;

  }

}

