#ifndef _JVoiceRecorder_H
#define _JVoiceRecorder_H


// Listens for record commands
// RecordON attach to the current voice as a monitor
// RecordOFF detach and save as a new phrase of focus track
// If conductor is playing record events
// else notify my observers about midi out event.


#include "JRecordEventList.h"
#include "JMidiOut.h"
#include "base/JOSTemplate.h"
#include "command/JRecorderCommand.h"

class JTrack;
class JVoice;
class JMidiOutEvent;
class JEventPhrase;
class JCommand;
class JContext;

class JVoiceRecorder : public JMidiOut,
		       public JObserver<JRecorderCommand,void>,
		       public JSubject<JMidiOutEvent,void>
{
public:
  JVoiceRecorder(JContext *);
  virtual ~JVoiceRecorder();
  void handle(JMidiOutEvent event);
  void handle(JRecorderCommand);

  bool  isArmed() const { return _voice != 0; }

  const char *name() const { return "VoiceRecorder";}
private:
  void saveToTrack();

  JRecordEventList _recordSequence;
  JTrack *         _track;
  JVoice *         _voice;
  JContext *       _context;
};


#endif
