#include <iostream.h>

#include "JPhrase.h"
#include "seq/JMetaSequencer.h"
#include "JGestureList.h"
#include "rep/JReader.h"
#include "seq/JPhraseSequencer.h"
#include "seq/JLoopPhraseSequencer.h"
//#include "JPhraseNotator.h"

JPhrase::JPhrase(JPlayer *player,JTrack *track,JPart *part,JGestureList *gList)
  : _player(player),
    _track(track),
    _part(part),
    _controller(0),
    _loopLeft(0),
    _loopRight(0),
    _loopCount(1),
    _update(this)
{

  if (gList == 0) {
    _gestureList=new JGestureList;
  } else {
    _gestureList=gList->clone();
  }

}


JPhrase::~JPhrase()
{
  delete _gestureList;
}

const JPhraseController *
JPhrase::controller() const
{
  return _controller;
}

JPhraseController *
JPhrase::controller()
{
  return _controller;
}

JPhrase *
JPhrase::clone(JTrack *track)
{
  if (track==0) track=_track;
  JPhrase *clone=new JPhrase(_player,track,_part,_gestureList);
  return clone;
}


void 
JPhrase::setLoopLeft(JBeat left)
{
  _loopLeft=left;
}

void
JPhrase::setLoopRight(JBeat right)
{
  _loopRight=right;
}

void 
JPhrase::setLoopCount(int loops)
{
  _loopCount=loops;
}




JBeat
JPhrase::loopLeft() const
{
  return _loopLeft;
}

JBeat
JPhrase::loopRight() const
{
  return _loopRight;
}

int
JPhrase::loopCount() const
{
  return _loopCount;
}

// JNotator *
// JPhrase::createNotator(JScorePainter *p) const
// {
//   return new JPhraseNotator(p,this);
// }

JSequencer *
JPhrase::createSequencer(JPlayer *player) const
{

  if  ( player == 0) player=_player;

  if ( _loopCount > 1 ) 
    return new JLoopPhraseSequencer(this,player);
  else  
    return new JPhraseSequencer(this,player);
}


void
JPhrase::appendGesture(JGesture *gesture)
{
  // Assume we build from the start.
  // Just (much) less time sorting before playback
  _gestureList->append(gesture);
}


void
JPhrase::insertGesture(JGesture *gesture)
{
  // Assume we build from the start.
  // Just (much) less time sorting before playback
  _gestureList->insert(gesture);
}

  
bool
JPhrase::write(ostream &out) const
{
  out << "$Phrase " <<  _loopLeft << " " <<  _loopRight << " " << _loopCount << endl;
  _gestureList->write(out);
  out << "$End" << endl;
  return out.fail();
}


bool
JPhrase::read(JReader &in)
{

  in.getBeat(_loopLeft);
  in.getBeat(_loopRight);
  in.getInt(_loopCount);
  return _gestureList->read(in);
}


void
JPhrase::update()
{
  if (!_update.empty())
    notifyObservers(_update );

  _update.done();

}

