#ifndef _JGesture_H
#define _JGesture_H

#include "JSequence.h"
#include "rep/JStyle.h"
#include "base/JName.h"


class JScorePainter;
class JNotator;
class JScorePainter;
class ostream;
class JNoteGesture;
class JReader;

class JGesture : public virtual JSequence
{

protected:
  virtual ~JGesture();

friend class JGestureFactory;
  // only a factory can create using balnk constructor
  JGesture();

public:
  JGesture(JBeat start);


  virtual  JGesture *    clone() const=0;

  //  virtual  JNotator *    createNotator(JScorePainter *) const = 0;

  virtual  void shiftBy(JDuration d) { _start += d; }

  virtual  bool         tweak(double val=1.0,int index=0);
  virtual  const char **tweakNames() const;
  virtual  bool         write(ostream &) const=0;
  virtual  bool         read(JReader &)=0;
  virtual  const char * typeName() const=0;

  virtual JBeat         start() const { return _start; }
  bool                  isType(const char *name) const;

  virtual bool          contains(JBeat b) const { return (b < end() && b >=start()); }
  virtual bool          valid()     const { return (end() >= start()); }
  virtual JLRRep        lrRep()     const { return JLRRep(start(),end()); }
  virtual JDuration     duration()  const = 0;
  virtual JBeat         end()       const { return start() + duration(); }


//   bool     writeBase(ostream &) const;
//   bool     readBase(JReader &);

  JGesture * next() { return _next; }
  JGesture * prev() { return _prev; }

  // hack city
  virtual JNoteGesture *noteGesture() { return 0; }

protected:

  friend class JGestureList;
  friend class JGestureListIterator;

  JBeat      _start;

  JGesture * _prev;
  JGesture * _next;
  
};

inline
bool
JGesture::tweak(double,int)
{
  return false;
}

#endif


