#ifndef _JDeviceManager_H
#define _JDeviceManager_H

#include "JMidiOut.h"

/*!

 \class JDeviceManager   JDeviceManager.h
 \brief Singleton. Defines the interface for a list of devices. 

*/


#include "assert.h"

class JMidiIn;
class JDevice;
class JMidiOutEvent;
class JEffectList;
class JDevice;

// TODO resizing array
#define MAX_OUT_DEVICE 10
#define MAX_IN_DEVICE 10

class JDeviceManager : public JMidiOut
{
protected:
  JDeviceManager();
public:
  virtual ~JDeviceManager(){;}

  static JDeviceManager *the();  // singleton

  int          nOutDevice() const;
  JDevice *    outDevice(int i);
  void         addOutDevice(JDevice *device);
  JEffectList * newDeviceEffectList(int dev);
  JMidiIn *    midiIn(int i);
  int          nInDevice() const;
  void         addInDevice(JMidiIn *in);
  void         handle(JMidiOutEvent);
  const    char *name() const { return "DeviceManager"; }
protected:
  JDevice *    _outDevice[MAX_OUT_DEVICE];
  int          _nOut;
  JMidiIn *    _inDevice[MAX_IN_DEVICE];
  int          _nIn;
  static JDeviceManager *_the;
};


#endif






