#ifndef _JBeatToX_H
#define _JBeatToX_H

#include "rep/JBeat.h"
#include "rep/JLRRep.h"

class JBeatToX 
{
public:
  JBeatToX(int metric,
	   int x,
	   int width);

  int x() const {return _x;}
  JBeat beatAt(int x) const;
  int width() const {return _width;}
  bool setFocus(const JBeat &beat,bool smooth=true);
  bool setFocusAt(JBeat beat,int x);

  /// Set the starting point.
  void setLeft(const JBeat &left);

  /// Return the right hand.
  JBeat start() const;

  /// Return the left hand.
  JBeat end() const;

  int    x(const JBeat &beat) const;
  void   set(int x,int width);

  JLRRep lrRep() const { return JLRRep(start(),end());}

protected:

  int             _qmetric;
  int             _xZero;      // Where JBeat(0) would lie
  int             _x;
  int             _width;
  JBeat           _leftBeat;
  JBeat           _rightBeat;
  JDuration       _jump;
  JDuration       _jumpSmooth;
  JDuration       _tol;
};

#endif
