#ifndef _JBPT_H
#define _JBPT_H

/*!
  \class JBPT JBPT.h
  \brief
*/

#include "rep/JBeat.h"
#include "base/JOSTemplate.h"

class JToBPT;

class JBPT:public JObserver<const JToBPT *,void>,
	   public JSubject<const JBPT *,void>,
	   public JName
{
public:
  JBPT(const JToBPT *toBPT,const char *name);
  ~JBPT(){;}

  //! If my reference frame changes
  void handle(const JToBPT *);

  void addTicks(int ticks,bool quiet=false);
  void addPulses(int pulses,bool quiet=false);
  void addBars(int bars,bool quiet=false);

  void setTick(int ticks,bool quiet=false);
  void setPulse(int pulses,bool quiet=false);
  void setBar(int bars,bool quiet=false);
  void setBeat(JBeat beat,bool quiet=false);

  int bar() const         { return  _bar; }
  int pulse() const      { return  _pulse; }
  int tick() const        { return  _tick; }

  int    pulsesInBar() const  { return _pulsesInBar; }
  int    ticksInPulse() const { return _ticksInPulse; }
  JBeat  beat() const         { return _beat; }

private:

  //  void rebuildBeat(bool quiet=false);

  const JToBPT * _toBPT;
  int      _bar;
  int      _pulse;
  int      _tick;
  JBeat    _beat;
  int      _ticksInPulse;
  int      _pulsesInBar;

};


#endif

