#include <iostream.h>
#include <unistd.h>

#include <qapp.h>

#include "japp/JApplication.h"

#include "jam/JContext.h"
#include "jam/JDeviceManager.h"  //  /dev/sequencer interface
#include "jam/JMidiIn.h"
#include "jam/JVoice.h"
#include "jam/JVoiceManager.h"

#include "qj/QJVoiceWidget.h"

int main(int argc,char **argv)
{
  // Wrapper for /dev/sequencer
  QApplication app(argc,argv);
  JApplication japp;
  JContext *context=new JContext();

  JMidiIn *midiIn=JDeviceManager::the()->midiIn(0);

  assert(midiIn != 0);

  JVoice *voice =   JVoiceManager::the()->defaultVoice();

  midiIn->attach(voice);

  QJVoiceWidget voiceWidget(context);

  app.setMainWidget(&voiceWidget);

  voiceWidget.show();

  app.exec();

}










