#include <iostream.h>
#include "flowanal.h"
#include "flowblk.h"
#include "rhytmblk.h"
#include "phrase.h"
#include "iterator.h"

flow_analyse_c::flow_analyse_c(){
  phrase_ptr = 0;
  flow_array_ptr = 0;
}

flow_analyse_c::flow_analyse_c(phrase_c *phrase_p){
  phrase_ptr = phrase_p;
  flow_array_ptr = 0;
}

void flow_analyse_c::flow_analyse(){
  int *start_beat_p;
  int *end_beat_p;
  int no_notes_in_flow_i;
  int flow_direction_i;
  int next_direction_i;
  int no_flow_blocks_i;
  int loop_i;
  int start_storing_i;
  int last_flow_end_note_i;
  char d;

  remove_all();

  phrase_ptr->iterator()->set_iterator(phrase_ptr->phrase(),
													phrase_ptr->phrase());
  for(loop_i = 0; loop_i < 3; loop_i++){
	 no_notes_in_flow_i = 0;
	 no_flow_blocks_i = 0;
	 flow_direction_i = 0;
	 next_direction_i = 0;
	 start_storing_i = 0;

	 start_beat_p = phrase_ptr->iterator()->rhythm_block()->array();

	 do{
		if(loop_i == 2){
		  if(start_storing_i == 1)
			 flow_array_ptr[no_flow_blocks_i].flow_notes_array_ptr[0]
					  = last_flow_end_note_i;

		  flow_array_ptr[no_flow_blocks_i].
					  flow_notes_array_ptr[no_notes_in_flow_i]
					= phrase_ptr->iterator()->rhythm_block()->note_pntr()->note();
		}

		if(phrase_ptr->iterator()->rhythm_block()->rRlink()
			== phrase_ptr->phrase()){
			 end_beat_p = phrase_ptr->iterator()->rhythm_block()->array();
			 next_direction_i = - next_direction_i;
		}else if(phrase_ptr->iterator()->rhythm_block()->rRlink()->note_pntr()->
				 note() < phrase_ptr->iterator()->rhythm_block()->note_pntr()->
				 note()){
		  if(flow_direction_i == 1){
			 end_beat_p = phrase_ptr->iterator()->rhythm_block()->array();
			 next_direction_i = -1;
		  }else if(flow_direction_i == 0){
			 flow_direction_i = -1;
			 next_direction_i = -1;
		  }
		}else if(phrase_ptr->iterator()->rhythm_block()->rRlink()->note_pntr()->
				 note() > phrase_ptr->iterator()->rhythm_block()->note_pntr()->
				 note()){
		  if(flow_direction_i == -1){
			 end_beat_p = phrase_ptr->iterator()->rhythm_block()->array();
			 next_direction_i = 1;
		  }else if(flow_direction_i == 0){
			 flow_direction_i = 1;
			 next_direction_i = 1;
		  }
		}

		no_notes_in_flow_i++;

		if((flow_direction_i != next_direction_i)||(next_direction_i == 0)){
		  if(loop_i == 1){
			 flow_array_ptr[no_flow_blocks_i].no_notes_in_flow_int
														 = no_notes_in_flow_i;
			 flow_array_ptr[no_flow_blocks_i].flow_notes_array_ptr
										  = new int[no_notes_in_flow_i];
			 if(flow_array_ptr[no_flow_blocks_i].flow_notes_array_ptr == 0){
				cout << "FATAL ERROR: Cannot allocate memory..." << endl;
				cin.get(d);
			 }
			 flow_array_ptr[no_flow_blocks_i].start_beat_ptr
										  = new beat_block_c(start_beat_p);
			 if(flow_array_ptr[no_flow_blocks_i].start_beat_ptr == 0){
				cout << "FATAL ERROR: Cannot allocate memory..." << endl;
				cin.get(d);
			 }
			 flow_array_ptr[no_flow_blocks_i].end_beat_ptr
										  = new beat_block_c(end_beat_p);
			 if(flow_array_ptr[no_flow_blocks_i].end_beat_ptr == 0){
				cout << "FATAL ERROR: Cannot allocate memory..." << endl;
				cin.get(d);
			 }
		  }else if(loop_i == 2){
			 flow_array_ptr[no_flow_blocks_i].interval_int
								= flow_array_ptr[no_flow_blocks_i].
								  flow_notes_array_ptr[no_notes_in_flow_i - 1]
								- flow_array_ptr[no_flow_blocks_i].
								  flow_notes_array_ptr[0];
		  }

		  last_flow_end_note_i = phrase_ptr->iterator()->rhythm_block()->
										 note_pntr()->note();
		  no_notes_in_flow_i = 1;
		  no_flow_blocks_i++;
		  flow_direction_i = - flow_direction_i;
		  start_beat_p = end_beat_p;
		  start_storing_i = 1;
		}

		phrase_ptr->iterator()->iterate(0, 1);

	 }while(phrase_ptr->iterator()->rhythm_block() != phrase_ptr->phrase());

	 if(loop_i == 0){
		flow_array_ptr = new flow_block_c[no_flow_blocks_i];
		if(flow_array_ptr == 0){
		  cout << "FATAL ERROR: Cannot allocate memory..." << endl;
		  cin.get(d);
		}
		no_flow_blocks_int = no_flow_blocks_i;
	 }
  }
}

int flow_analyse_c::flow_locate(int *array_p){
  int next_i = 0;
  int location_i = 4;
  int at_start_i;
  int at_end_i;
  int exit_i = 0;
  rhythm_block_c *rtmp_p;
  note_block_c *ntmp_p;

  current_note_element_int = 0;

  rtmp_p = phrase_ptr->iterator()->rhythm_block();
  ntmp_p = phrase_ptr->iterator()->note_block();

  while((exit_i == 0)&&(next_i < no_flow_blocks_int)){
	 at_start_i = phrase_ptr->compare_fractions(array_p,
					  flow_array_ptr[next_i].start_beat_ptr->array());
	 at_end_i = phrase_ptr->compare_fractions(array_p,
					  flow_array_ptr[next_i].end_beat_ptr->array());

	 if(at_start_i == 1){
		current_element_int = next_i;
		location_i = 1;
		exit_i = 1;
	 }else if(at_end_i == 1){
		current_element_int = next_i + 1;
		location_i = 2;
		exit_i = 1;
	 }else if((at_end_i == 2)){
		next_i++;
	 }else if((at_start_i == 2)||(at_end_i == 0)){
		phrase_ptr->find_rhythm_block(flow_array_ptr[next_i].start_beat_ptr->
												array());
		do{
		  phrase_ptr->iterator()->iterate(0, 1);
		  current_note_element_int++;
		}while(phrase_ptr->compare_fractions(phrase_ptr->iterator()->
				 rhythm_block()->array(), array_p) == 0 );
		current_element_int = next_i;
		location_i = 0;
		exit_i = 1;
	 }
  }

  if(phrase_ptr->compare_fractions(phrase_ptr->phrase()->rLlink()->array(),
	  array_p) == 1){
	 current_note_element_int = flow_array_ptr[next_i].no_notes_in_flow_int - 1;
	 current_element_int = next_i;
	 location_i = 3;
  }

  phrase_ptr->iterator()->set_iterator(rtmp_p, ntmp_p);

  /*
  Key for location:

  0) in flow
  1) phrase start
  2) flow start/(end)
  3) phrase end
  4) not found

  */

  return location_i;
}

void flow_analyse_c::display_flow(){

}

void flow_analyse_c::remove_all(){
  int a;

  if(flow_array_ptr != 0){
	 for(a = 0; a < no_flow_blocks_int; a++)
		flow_array_ptr[a].remove_all();

	 if(no_flow_blocks_int > 1)
		delete [] flow_array_ptr;
	 else
		delete flow_array_ptr;
  }
}

