// Please note "NO" checks have been made for object creation failure //
// i.e. lack of memory for creation //
// These will be coming //

#include <iostream.h>
#include <stdlib.h>
#include <fstream.h>
#include <ctype.h>
#include <string.h>
#include <iomanip.h>

// Objects //
#include "randcont.h"
#include "note.h"
#include "noteblk.h"
#include "beatblk.h"
#include "rhytmblk.h"
#include "iterator.h"
#include "phrase.h"
#include "rcorblk.h"
#include "rhytmcor.h"
#include "flowblk.h"
#include "flowanal.h"
#include "scaleanl.h"
#include "phradptr.h"
#include "phrasnfo.h"

#define N_CMD  34
#define N_CHAR 22

void initialise_values(char word_t[N_CMD][N_CHAR], int *variable_values_i){
  ifstream ini_s;
  int loop_i = 0;
  int pos_i;
  int length_i;
  int error_i = 0;
  //  int exit_i = 0;
  char number_t[6];
  char function_t[N_CHAR];
  char in_t;
  char d;

  cout << "Composer V0.95\n\n";
  cout << "Julian Sweeting\n";
  cout << "copyright 'University of Bath'\n\n";

  ini_s.open("composer.ini");

  if(ini_s.fail()){
	 cout << "Error: Composer.ini could not be found/opened...\n\n";
	 cout << "Composer not run.\n\n";
	 exit(1);
  }

  ini_s >> in_t;

  while((!ini_s.eof())&&(error_i == 0)){
	 pos_i = 0;
	 strcpy(number_t,"      ");

	 while(isalpha(in_t)&&(!ini_s.eof())){
		word_t[loop_i][pos_i] = in_t;
		ini_s >> in_t;
		pos_i++;
	 }

	 length_i = strlen(word_t[loop_i]);

	 for(pos_i = 0; pos_i < length_i; pos_i++)
		word_t[loop_i][pos_i] = toupper(word_t[loop_i][pos_i]);

	 pos_i = 0;

	 switch(loop_i){
		case 0: strcpy(function_t, "RANDOM");
				  break;
		case 1: strcpy(function_t, "SCALEMORPH");
				  break;
		case 2: strcpy(function_t, "SCALEMORPHLIMIT");
				  break;
		case 3: strcpy(function_t, "ADJUSTSCALEVARIANCE");
				  break;
		case 4: strcpy(function_t, "LOW");
				  break;
		case 5: strcpy(function_t, "MIDL");
				  break;
		case 6: strcpy(function_t, "MIDH");
				  break;
		case 7: strcpy(function_t, "HIGH");
				  break;
		case 8: strcpy(function_t, "FIXSTARTNOTELOCATION");
				  break;
		case 9: strcpy(function_t, "FIXSTARTNOTEPITCH");
				  break;
		case 10: strcpy(function_t, "INCREASELENGTH");
				  break;
		case 11: strcpy(function_t, "BEAT");
				  break;
		case 12: strcpy(function_t, "NUMERATOR");
				  break;
		case 13: strcpy(function_t, "DENOMINATOR");
				  break;
		case 14: strcpy(function_t, "PROCESSLOOPS");
				  break;
		case 15: strcpy(function_t, "NOTECHANGES");
				  break;
		case 16: strcpy(function_t, "CORRELATIONSHUFFLES");
				  break;
		case 17: strcpy(function_t, "CORRELATIONINCREASES");
				  break;
		case 18: strcpy(function_t, "CORRELATIONDECREASES");
				  break;
		case 19: strcpy(function_t, "NOTEINTRODUCTIONS");
				  break;
		case 20: strcpy(function_t, "CORRNOTEINTRODUCTIONS");
				  break;
		case 21: strcpy(function_t, "NOTEELIMINATIONS");
				  break;
		case 22: strcpy(function_t, "BLOCKELIMINATIONS");
				  break;
		case 23: strcpy(function_t, "CORRNOTEELIMINATIONS");
				  break;
		case 24: strcpy(function_t, "CORRBLOCKELIMINATIONS");
				  break;
		case 25: strcpy(function_t, "RHYTHMCORRLOW");
				  break;
		case 26: strcpy(function_t, "RHYTHMCORRMIDL");
					break;
		case 27: strcpy(function_t, "RHYTHMCORRMIDH");
				  break;
		case 28: strcpy(function_t, "RHYTHMCORRHIGH");
				  break;
		case 29: strcpy(function_t, "SMALLFRACTIONVALUE");
				  break;
		case 30: strcpy(function_t, "FSLOW");
				  break;
		case 31: strcpy(function_t, "FSMIDL");
				  break;
		case 32: strcpy(function_t, "FSMIDH");
				  break;
		case 33: strcpy(function_t, "FSHIGH");
				  break;
	 }

	 if(!strcmp(word_t[loop_i], function_t)){
		while(isdigit(in_t)&&(!ini_s.eof())){
		  number_t[pos_i] = in_t;
		  ini_s >> in_t;
		  pos_i++;
		}

		switch(loop_i){
		  case 0:  srand(atoi(number_t));
					  break;
		  default: variable_values_i[loop_i - 1] = atoi(number_t);
					  break;
		}
		loop_i++;
	 }else{
		error_i = 1;
		cout << "Error: Composer.ini is corrupt...\n\n";
		cout << "Composer not run.\n\n";
		exit(1);
	 }
  }
  ini_s.close();
}

void end_update(char word_t[N_CMD][N_CHAR], int *variable_values_i){
  int a;
  int b;
  int random_i;
  int length_i;
  ofstream inio_s;
  inio_s.open("composer.ini");
  random_i = rand();

  if(!inio_s.fail()){
	 length_i = strlen(word_t[0]);
	 for(a = 0; a < length_i; a++)
		inio_s << word_t[0][a];
	 inio_s << " " << random_i << endl;

	 for(b = 1; b < N_CMD; b++){
		length_i = strlen(word_t[b]);
		for(a = 0; a < length_i; a++)
		  inio_s << word_t[b][a];
		inio_s << " " << variable_values_i[b - 1] << endl;
	 }

	 inio_s.close();
  }else
	 cout << "Error: Failed to update RANDOM in compose.ini...\n\n";

  cout << "Composer has finished" << endl;
}

void retreive_phrase(phrase_adapter_c *adapter_p){
  note_info_c *note_info_p;
  phrase_info_c *phrase_info_p;
  int end_i;
  char d;

  note_info_p = new note_info_c;
  if(note_info_p == NULL){
	 cout << "FATAL ERROR: Cannot allocate memory..." << endl;
	 cin.get(d);
  }
  phrase_info_p = new phrase_info_c;
  if(phrase_info_p == NULL){
	 cout << "FATAL ERROR: Cannot allocate memory..." << endl;
	 cin.get(d);
  }

  // Retreive new phrase //

  adapter_p->get_info(1, phrase_info_p);

  /*
  cout << "Tempo " << phrase_info_p->tempo_int << endl;
  cout << "Beats in Bar" << phrase_info_p->beats_in_bar_int << endl;
  cout << "Beat Type" << phrase_info_p->beat_type_int << endl << endl;
  */

  adapter_p->setup_read();

  do{
	 end_i = adapter_p->get_note(1, note_info_p);

	 /*
	 cout << "Beat " << note_info_p->beat_int << endl;
	 cout << "Num " << note_info_p->numerator_int << endl;
	 cout << "Denom " << note_info_p->denominator_int << endl;
	 cout << "Note " << note_info_p->note_int << endl;
	 cout << "Length " << note_info_p->length_dbl << endl;
	 cout << "Velocity " << note_info_p->velocity_int << endl;
	 cin.get(d);
	 */

  }while(end_i == 0);

  delete note_info_p;
  delete phrase_info_p;
}

int main(void){
  static int variable_values_i[N_CMD - 1];
  static char word_t[N_CMD][N_CHAR];

  char d;
  phrase_adapter_c *adapter;

  // Tchaikovsky, Fantasy Overture, Hamlet //

  initialise_values(word_t, variable_values_i);

  adapter = new phrase_adapter_c(130, 3, 4, 1, 0, 0, 64, 2, 127);
  if(adapter == NULL){
	 cout << "FATAL ERROR: Cannot allocate memory..." << endl;
	 cin.get(d);
  }

  adapter->add_note(3, 0, 0, 64, 1.5, 127);
  adapter->add_note(4, 1, 2, 59, 0.5, 127);
  adapter->add_note(5, 0, 0, 62, 1, 127);
  adapter->add_note(6, 0, 0, 60, 3, 127);
  adapter->add_note(9, 0, 0, 57, 0.5, 127);
  adapter->add_note(9, 1, 2, 59, 0.5, 127);
  adapter->add_note(10, 0, 0, 60, 0.5, 127);
  adapter->add_note(10, 1, 2, 64, 0.5, 127);
  adapter->add_note(11, 0, 0, 62, 1.5, 127);
  adapter->add_note(12, 1, 2, 62, 0.5, 127);
  adapter->add_note(13, 0, 0, 62, 4, 127);

  adapter->set_variables(variable_values_i);

  adapter->process_phrase();

  /*
  retreive_phrase(adapter);
  */
  adapter->remove_all();
  delete adapter;

  end_update(word_t, variable_values_i);

  return 0;
}



  /* // This shows the data that a new phrase requires //

  int tempo

	 // These indented ones also apply to the add note function futher down //
	 int beat (integer value starting on "1")
	 int beat fraction numerator (if 0, numerator = 0, denominator = 1)
	 int beat fraction denominator (if 0, numerator = 0, denominator = 1)
	 int note value (0,12,24 etc. correspond to NOTE "C" (1,13 etc. "C#")
	 double length
	 int velocity

  int number of beats in a bar (2,3,4 etc.. )
  int type of beat (i.e. 1 = whole, 2 = half , 4 = quater note )

  */
