/* collects data on the length between zero-crossings. */

#include <stdio.h>
#include <assert.h>
#include <string.h>

#include "plugin_specific.h"
#include "aiff.h"

#define BINS    40
#define BINSIZE 5

static long histogram[BINS+1] = {0};

void init_process_zerocross( void )
{
   if ( nh.wdsi != 8 ) err( "Cannot process a file with this word size" );
   if ( nh.chan != 1 ) err( "Cannot process a multichannel file" );
}

void term_process_zerocross ( void )
{
#define BARMAX 60
   int i, barlen;
   long histmax = 0;
   char bar[80];

   memset( bar, '*', BARMAX );
   
   for (i=0; i<BINS; i++)
      if (histogram[i] > histmax) histmax = histogram[i];

   printf( "out of range: %ld\n", histogram[BINS] );
   for (i=0; i<BINS; i++)
   {
      barlen = (float) BARMAX * histogram[i]/histmax;
      printf( "[%.3d...%.3d): %.4ld %.*s\n",
               i*BINSIZE, (i+1)*BINSIZE, histogram[i], barlen, bar );
   }
}

void bin ( long len )
{
   assert( len > 0 );
   if ( len < BINS*BINSIZE ) histogram[len/BINSIZE]++;
   else histogram[BINS]++;
}

void process_samdat_zerocross ( long buflen )
{
   register char *td, *endd;
   static char last = 0;
   static long abs_pos = 0, last_zero = 0;
   
   td   = d;
   endd = &td[buflen];
   
   do
   {
      if ( (*td > 0) != (last > 0) )
      {
         bin( abs_pos - last_zero );
         last_zero = abs_pos;
      }
      last = *td;
      abs_pos++;
      td++;
   }
   while ( td < endd );
}

plugin_info plugin_zerocross =
{
   init_process_zerocross,
   term_process_zerocross,
   process_samdat_zerocross,
   1, /* take_input */
   0  /* make_output */
};
