/* displays the waveform in an AIFF file. */

#include <stdio.h>
#include <string.h>
#include <limits.h>
#ifdef THINK_C
#include <console.h>
#endif

#include "plugin_specific.h"
#include "aiff.h"

static FILE *tmpfil;

void init_process_view( void ) {
   if ( nh.wdsi != 8 && nh.wdsi != 16 )
      err( "Cannot process a file with this word size" );
   if ( (nh.chan != 1) )
      err( "Cannot process a multichannel file" );
   if ( USHRT_MAX != 65535 )
      err( "this plugin is based on the assumption of 2 byte shorts" );
   
   tmpfil = tmpfile();
}

void process_samdat_view( long buflen ) {
   fwrite( d, buflen*nh.framsiz, 1, tmpfil );
}

#define ROWS    23
#define TOTCOLS 80
#define COLS    TOTCOLS-7
#define TOTROWS ROWS+1

static char s[(TOTCOLS+1)*TOTROWS+1] = "", *tmps;

void samstr_view( short samval ) {
   static char spaces[COLS+1] = "";
   int col_i;
   
   if ( !*spaces ) memset( spaces, ' ', COLS );
   
#define WS nh.wdsi
   col_i = (samval+(1L<<(WS-1))) * (COLS+1) / (1L<<WS);

   sprintf( tmps, "%6d%.*s|\n", samval, col_i, spaces );
   tmps += col_i + 8;
}

void term_process_view ( void ) {
   char c, *tbuf_char;
   short buf[ROWS], *tbuf_short, i, ofs = 0;

#ifdef THINK_C
   csetmode( C_CBREAK, stdin );
#endif
   fseek( tmpfil, 0, SEEK_SET );
   
   do {
      fseek( tmpfil, ofs * nh.framsiz, SEEK_CUR );
      fread( buf, ROWS * nh.framsiz, 1, tmpfil );
#ifdef THINK_C
      cgotoxy( 1, 1, stdout );
      ccleos( stdout );
#endif
      tmps = s;

      if ( nh.framsiz == 2 )
         for (i=0, tbuf_short=buf; i<ROWS; i++) samstr_view( *tbuf_short++ );
      else
         for (i=0, tbuf_char=(char *) buf; i<ROWS; i++)
            samstr_view( *tbuf_char++ );

      fprintf( stderr, "%sfile pos: %ld (d/u line, f/b screen, x exit) ",
               s, ftell( tmpfil ) );
      
      c = getchar();
#ifndef THINK_C
      getchar();
#endif
      ofs = -ROWS + (( c == 'b' ) ? -ROWS : 
                     ( c == 'f' ) ?  ROWS :
                     ( c == 'r' ) ? -10*ROWS :
                     ( c == 'l' ) ?  10*ROWS :
                     ( c == 'u' ) ? -1 :
                     ( c == 'd' ) ?  1 : 0 );
   } while ( c != 'x' );
   
   fclose( tmpfil );
}
plugin_info plugin_view = { init_process_view,
   term_process_view, process_samdat_view, 1, 0 };
