/*
FILE:    sintab.h
PROJECT: Ford grant DSP
AUTHOR:  Ben Denckla
COMMENT: constants, externs, and function declarations for sine table routines
*/

#define QSIZLOG2 9                /* quadrant size LOG base 2. (1) */
#define QSIZ     (1U << QSIZLOG2) /* quadrant size */
#define TABMASK  (4*QSIZ - 1)     /* 4-quadrant sine table mask: x & TABMASK == x % 4QSIZ */

/* 1. QSIZLOG2 must be <= 13 in order to address the whole 4-quadrant sine table with a short since the max of a short is 1<<15 - 1.  See get_sintab4() in "sintab.c". */

short  getusrharm  ( double rate );
void   get_sintab  ( void );
short *gen_sintab4 ( void );
short  sin_tab     ( short tabi );
short  fsin_tab    ( double *fsamnum );

