/* generates a sine wave of user-specified frequency */

#include <stdio.h>
#include <math.h>
#include <limits.h>

#include "plugin_specific.h"
#include "aiff.h"
#include "type_conversion.h"
#include "sintab.h"
#include "num_input_macros.h"

static short harm;

void init_process_sinegen( void ) {
   if ( USHRT_MAX != 65535 )
      err( "this plugin is based on the assumption of 2 byte shorts" );

   get_sintab(); /* get a 1st-quadrant sine wave table */

   /* set AIFF header info (all else is default) */
   nh.chan = 1;
   nh.wdsi = 16;
   nh.framsiz = 2;
   GET_NUM_P( "number of samples", "%ld", nh.fram );
   GET_NUM_P( "sampling rate",     "%lg",  nh.rate );

   harm = getusrharm( nh.rate );
}

void term_process_sinegen( void ) {
}

void process_samdat_sinegen( long buflen ) {
   register short *td, *endd, tphase, tharm;
   static short phase = 0;
   
   td     = d;
   tphase = phase;
   tharm  = harm;
   endd   = &td[buflen];

   do {
      *td++ = sin_tab( tphase &= TABMASK );
      tphase += tharm;
   } while ( td < endd );
   
   phase = tphase;
}

plugin_info plugin_sinegen = { init_process_sinegen,
   term_process_sinegen, process_samdat_sinegen, 0, 1 };
