/* ringmod.c: implements fixed-frequency sinusoidal-carrier ring modulation.*/

#include "plugin_specific.h"
#include "aiff.h"
#include "sintab.h"
#include <stdlib.h>
#include <limits.h>

static short *sintab4, harm;

void init_process_ringmod( void )
{
   if ( nh.wdsi != 16 )
      err( "Cannot process files with word size not equal to 16 bits" );
   if ( USHRT_MAX != 65535 )
      err( "this plugin is based on the assumption of 2 byte shorts" );

   get_sintab();                 /* get a 1st-quadrant sine wave table */
   sintab4 = gen_sintab4();      /* generate a 4-quadrant sine wave table */
   harm = getusrharm( nh.rate ); /* get harmonic desired from user */
}

void term_process_ringmod( void )
{
   free ( sintab4 );
}

void process_samdat_ringmod( long buflen )
{
   register long  t;
   register short *td, *tsintab4, tharm, tphase, ttabmask;
   static short phase = 0;
   int chan, fram;

   td       = d;
   tsintab4 = sintab4;
   tharm    = harm;
   tphase   = phase;
   ttabmask = TABMASK;

   for ( fram=0; fram < buflen; fram++ ) {
      for ( chan=0; chan < nh.chan; chan++ ) {
         t = (long) *td * tsintab4[ tphase &= ttabmask ];
#ifdef THINK_C
         asm { swap t }; /* 1 */
#else
         t >>= 16;
#endif
         *td++ = t;
      }
      tphase += tharm; /* 2 */
   }
   
   phase = tphase;
}
/*
1. To profile, use t >>= 16 instead.  (Can't profile a function w/ asm.)

loop:
00000026        AND.W     ttabmask,tphase
00000028        MOVE.W    $00(tsintab4,tphase.W*2),D7
0000002C        MULS.W    *td,D7
0000002E        SWAP      D7
00000030        MOVE.W    D7,*td++
00000032        ADD.W     harm,tphase
00000034        CMPA.L    td,end
00000036        BHI.S     loop
*/

plugin_info plugin_ringmod = {
   init_process_ringmod,
   term_process_ringmod,
   process_samdat_ringmod,
   1, /* take_input */
   1  /* make_output */
};
