/* macros useful for numerical input */

#define GET_NUM_P( prompt, scanfmt, x ) \
   fprintf( stderr, prompt " (must be positive): " ); \
   GET_NUM_COND( scanfmt, x, (x) > 0 )

#define GET_NUM_RANGE( prompt, printfmt, scanfmt, x, min, max ) \
   fprintf( stderr, prompt " [" printfmt "..." printfmt "]: ", min, max ); \
   GET_NUM_COND( scanfmt, x, (x) >= (min) && (x) <= (max) )

#define GET_NUM_COND( scanfmt, x, cond ) \
   while ( !( scanf( scanfmt, &(x) ) && (cond) ) ) \
   { \
      getchar(); \
      fprintf( stderr, "Try again (last input was illegal): " ); \
   } \
   getchar()
