/* displays the waveform in an AIFF file and does some analysis specific to magnetic card waveforms */

#include <stdio.h>
#include <string.h>
#ifdef THINK_C
#include <console.h>
#endif

#include "plugin_specific.h"
#include "aiff.h"
#include "card.h"

static FILE *tmpfil, *peakfil;

void init_process_cardread( void ) {
   if (nh.wdsi != 8) err( "Cannot process a file with this word size" );
   if (nh.chan != 1) err( "Cannot process a multichannel file" );
   
   tmpfil  = tmpfile();
   peakfil = tmpfile();
}

#define FLAGVAL 129

void process_samdat_cardread( long buflen ) {
#define THRESH 20
#define FLAG(x) ( (x<0) ? -FLAGVAL : FLAGVAL )
   
   short scratch, i;
   char *td = d;
   static long global_pos = 0;
   static char findmax = 0, max = 0;
   pkpt p;
   
   for (i=0; i<buflen; i++, global_pos++) {
      scratch = *td;
      if ( findmax && *td > max ) max = *td;
      if ( *td > THRESH ) findmax = 1;
      else
      {
         if ( findmax==1 )  /* if we were looking for max */
         {
            p.pos = global_pos;
            p.val = max;
            max = 0;
            fwrite( &p, sizeof p, 1, peakfil );
            scratch = FLAG(*td);
         }
         findmax = 0;
      }
      td++;
      fwrite( &scratch, 2, 1, tmpfil );
   }
}

#define ROWS    23
#define TOTCOLS 80
#define COLS    TOTCOLS-7
#define TOTROWS ROWS+1

static char s[(TOTCOLS+1)*TOTROWS+1] = "", *tmps;

void samstr( short samval )
{
   static char regspaces[COLS+1] = "", invspaces[COLS+1] = "";
   char *spaces;
   int col_i, wdsi = nh.wdsi;
   
   if ( !*regspaces ) memset( regspaces,        ' ', COLS );
   if ( !*invspaces ) memset( invspaces, 0x80 | ' ', COLS );
   
   if ( samval == FLAGVAL || samval == -FLAGVAL)
   {
      col_i = COLS;
      spaces = invspaces;
   }
   else
   { 
      col_i = (samval+(1L<<(wdsi-1))) * (COLS+1) / (1L<<wdsi);
      spaces = regspaces;
   }

   sprintf( tmps, "%6d%.*s|\n", samval, col_i, spaces );
   tmps += col_i + 8;
}

void view( void )
{
   char c;
   short buf[ROWS], *tbuf, i, ofs = 0;

#ifdef THINK_C
   csetmode( C_CBREAK, stdin );
   cinverse( TRUE, stdout );
#endif
   fseek( tmpfil, 0, SEEK_SET );
   
   do
   {
      fseek( tmpfil, ofs << 1, SEEK_CUR );
      fread( buf, ROWS << 1, 1, tmpfil );
#ifdef THINK_C
      cgotoxy( 1, 1, stdout );
      ccleos( stdout );
#endif
      tmps = s;

      for (i=0, tbuf=buf; i<ROWS; i++) samstr( *tbuf++ );

      fprintf( stderr,"%sfile pos: %ld (d/u line, f/b screen, x exit) ",
               s, ftell( tmpfil ) );

      ofs = -ROWS + (( (c = getchar()) == 'b' ) ? -ROWS : 
                     (  c              == 'f' ) ?  ROWS :
                     (  c              == 'r' ) ?  -10*ROWS :
                     (  c              == 'l' ) ?   10*ROWS :
                     (  c              == 'u' ) ? -1 :
                     (  c              == 'd' ) ?  1 : 0 );
   }
   while ( c != 'x' );
   
   fclose( tmpfil );
}

void term_process_cardread ( void )
{
   view();
   post_process( peakfil );
   fclose( peakfil );
}

plugin_info plugin_cardread = { init_process_cardread,
   term_process_cardread, process_samdat_cardread, 1, 0 };
