/*
FILE:    card.c
PROJECT: Ford grant DSP
AUTHOR:  Ben Denckla
COMMENT: Analyzes magnetic card waveform.
*/

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <string.h>

#include "aiff.h"
#include "card.h"

char *histogram( pkpt *p, short pts ) {
#define BARMAX 60
#define BINS 251

   char bar[BARMAX];
   static char d[200];
   char errstr[100];
   short i, barlen, hist[BINS] = {0}, hmax = 0, d1, d2 = 0, rat;
   
   for (i=1; i<pts; i++) {
      d1 = p[i].pos - p[i-1].pos;
      if ( d2==0 ) rat = 100;
      else rat = (double) 100 * d1/d2;
      if ( rat < BINS ) hist[rat]++;
      else
      {
         sprintf( errstr, "%hd out o\f bin range", rat );
         err( errstr );
      }
      d2 = d1;
   }
   memset( bar, '*', BARMAX );
   for (i=0; i<BINS; i++) if (hist[i] > hmax) hmax = hist[i];

   for (i=0; i<BINS; i++) {
      barlen = ((BARMAX+1) * hist[i])/(hmax+1);
      printf( "bin %4d: %5d %.*s\n", i, hist[i], barlen, bar );
   }
   return d;
}

void printout( pkpt *p, short pts) {
   short i;
   
   for (i=0; i<pts; i++) printf( "%ld\n", p[i].pos - p->pos );
}

void readinfil( FILE *peakfil, pkpt **p, short *pts ) {
   long int filsiz;

   assert( !fseek( peakfil, 0, SEEK_END ) );
   assert( (filsiz = ftell( peakfil )) != -1L );

   assert( *p = malloc( filsiz ) );
   *pts = filsiz / sizeof(pkpt);
   
   assert( !fseek( peakfil, 0, SEEK_SET ) );
   assert( fread( *p, filsiz, 1, peakfil ) );
   assert( !fclose( peakfil ) );
}


char map( char *s ) {
   short i; char tmp = 0, scratch[2];

   for (i=0; i<4; i++) if (s[3-i]) tmp |= 1<<i;
   sprintf( scratch, "%x", tmp );
   return *scratch;
}

void process_bits( char *d, short quads ) {
   char ld[200], *td, *tld, out[50], *tout;
   short i;
   
   td = &d[quads-1];
   tld = ld;
   
   for (i=0; i<quads; i++) {
      putchar( (*td) ? '1' : '.' );
      *tld++ = *td--;
   }
   putchar( '\n' );
   
   for (i=0; !ld[i]; i++); printf( "skipped %d zeroes\n", i );
   
   for (tout=out; i<quads; i+=5) *tout++ = map(&ld[i]);
   *tout = 0;
   printf( "%s\n", out );
}

void post_process ( FILE *peakfil ) {
   pkpt *p;
   char *d;
   short pts;
   
   readinfil( peakfil, &p, &pts );
   
   /*printout( p, pts ); */
   d = histogram( p, pts );
   
   /*process_bits( d, quads ); */

   free( p );
}
