/* creates a histogram of the amplitudes present in a signal */

#include "plugin_specific.h"
#include "aiff.h"
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <limits.h>

#define BINS_LOG2 4
#define BINS (1<<BINS_LOG2)
#define BIN_MASK (BINS-1)

static short min, max;
static long histogram[BINS] = {0};
static double sum_of_squares = 0.0;

void init_process_analyze( void ) {
   if ( nh.wdsi != 8 && nh.wdsi != 16 )
      err( "Cannot process a file with this word size" );
   if ( USHRT_MAX != 65535 )
      err( "this plugin is based on the assumption of 2 byte shorts" );
}

void term_process_analyze( void ) {
#define BARMAX 60

   double rms;
   int i, barlen;
   long hmax = 0;
   char bar[BARMAX+1];

   memset( bar, '*', BARMAX );
   
   rms = sqrt( sum_of_squares / (nh.chan * nh.fram) );
   
   for (i=0; i<BINS; i++)
      if ( histogram[i] > hmax ) hmax = histogram[i];
   
   printf( "rms val: %.1f\nmin: %6hd\nmax: %6hd\n", rms, min, max );
   
   for (i=0; i<BINS; i++) {
      barlen = BARMAX * (((double)histogram[i])/hmax);
      printf( "bin %4d: %8lX %.*s\n", i-BINS/2, histogram[i], barlen, bar );
   }
}

void process_samdat_analyze( long buflen ) {
   static char first_time = 1;
   short *tds, samval;
   char  *tdc;
   long i, ofs_samval, bin;

   tds = d;
   tdc = d;
   if ( first_time )
   {
      min = max = (nh.wdsi==8) ? *tdc : *tds;
      first_time = 0;
   }
   for (i=0; i < buflen; i++)
   {
      samval = (nh.wdsi==8) ? *tdc++ : *tds++;
      if      ( samval < min ) min = samval;
      else if ( samval > max ) max = samval;
      sum_of_squares += ((long) samval) * samval;

      ofs_samval = samval + (1L << (nh.wdsi-1));
      bin = ofs_samval >> ( nh.wdsi - BINS_LOG2 );
      if ( (bin & BIN_MASK) != bin ) err( "bin calculation gone wild" );
      histogram[ bin ]++;
   }
}

plugin_info plugin_analyze = { init_process_analyze,
   term_process_analyze, process_samdat_analyze, 1, 0 };
