/* handles plugin selection & execution */

#include <stdio.h>
#include <string.h>

#include "aiff.h"
#include "plugin_specific.h"

#define DECLARE_PLUGIN( plugin_arg ) extern plugin_info plugin_##plugin_arg;

#define MAX_PLUGINS 50

DECLARE_PLUGIN( sinegen )
DECLARE_PLUGIN( ringmod )
DECLARE_PLUGIN( view )
DECLARE_PLUGIN( cardread )
DECLARE_PLUGIN( chebyshev )
DECLARE_PLUGIN( zerocross )
DECLARE_PLUGIN( analyze )
DECLARE_PLUGIN( null )


static plugin_info plugin[MAX_PLUGINS];

#define PLUGIN( plugin_arg ) \
   fprintf( stderr, "%d. "#plugin_arg"\n", i ); \
   plugin[i] = plugin_##plugin_arg; \
   i++; \

plugin_info *select_plugin( void ) {
#define S_LEN 10
   int i = 0, plugin_num = -1;
   char s[S_LEN];

   PLUGIN( ringmod )
   PLUGIN( sinegen )
   PLUGIN( view )
   PLUGIN( cardread )
   PLUGIN( chebyshev )
   PLUGIN( zerocross )
   PLUGIN( analyze )
   PLUGIN( null )

   fprintf( stderr, "\nEnter plugin number: (0..%d): ", i-1 );
   fgets( s, S_LEN, stdin );
   sscanf( s, "%d", &plugin_num );
   if ( plugin_num < 0 || plugin_num >= i )
      err( "select_plugin: Invalid plugin number" );
   
   return &(plugin[plugin_num]);
}
