#include <stdio.h>
#include <string.h>
#include "generic.h"
#include "aiff.h"

void safe_gets( char *s, int max_len )
{
   int len;

   fgets( s, max_len, stdin );
   len = strlen(s);
   if (len && s[len-1] == '\n')
      s[len-1] = 0;
}

int generic_getfstr( char *infstr, int len )
{
   fprintf( stderr, "input AIFF file name: " );
   safe_gets( infstr, len );
   return 0;
}

FILE *generic_open_ouf( void )
{
#define OUFSTR_LEN 300
   char oufstr[OUFSTR_LEN];
   FILE *ouf;

   fprintf( stderr, "output AIFF file name: " );
   safe_gets( oufstr, OUFSTR_LEN );
   if ( !( ouf = fopen( oufstr, "wb" ) ) )
      err( "opening output file" );
   return ouf;
}
