#include "aiff.h"
#include "Think_C.h"
#include "interface.h"
#include <console.h>

void Think_C_init( char **argvp[] )
{
	console_options.title = "\pDenckla Ford Grant AIFF DSP";	
	ccommand( argvp );
}

int Think_C_getfstr( char *infstr, int len )
{
	Point where = { 64, 64 };
	SFTypeList types = { 'AIFF' };
	int numtyp = 1;

	return getfullfstr( where, numtyp, types, infstr );
}

FILE *Think_C_open_ouf( void )
{
	long tmp_ftype;
	Point where = { 64, 64 };
	char oufstr[256] = "Untitled";
	FILE *ouf;

	if ( putfullfstr( where, "Save AIFF file to:", oufstr ) )
		err( "getting output file name" );
	tmp_ftype = _ftype; /* save _ftype */
	_ftype = 'AIFF';
	if ( !( ouf = fopen( oufstr, "wb" ) ) )
		err( "opening output file" );
	_ftype = tmp_ftype; /* restore _ftype */
	return ouf;
}
