*---------------------------INRS-Telecommunications---------------------------
*
*
* MODULE:
*       SUBROUTINE VTINIT (OPTION)
*
*
* PURPOSE:
*       This subroutine sets up a VTxxx terminal with Remote Graphics
*       Instruction Set (ReGIS) for plotting.
*
*
* DESCRIPTION:
*       This subroutine (optionally) clears the screen of the terminal
*       and draws a dark vector to the plot origin. The plot commands
*       are written to the standard output by default.
*
*
* PARAMETERS:
* C ->  OPTION - Character string specifying the options. Options are
*                separated by commas. If any option is omitted, the
*                default value is used. An all blank string gives the
*                default values. The same keyword may appear more than
*                once with the last instance taking precedence. The
*                CLEAR and OVERLAY options apply only to one invokation
*                of this routine.
*                CLEAR - The screen is erased. CLEAR is the default
*                  option if this plot device is not active.
*                OVERLAY - The screen is not erased. OVERLAY is the
*                  default option if this plot device is already active.
*                FILENAME=name - Specifies the name of the file or
*                  terminal to which plot data is sent. The file name is
*                  not used if this plot device is already active. The
*                  default file name is the logical name VTPLOT if the
*                  logical name VTPLOT is defined and TT otherwise. In
*                  the latter case, the plot data is directed to the
*                  controlling terminal.
*
*
* ROUTINES REQUIRED:
*       FNDPAR - Separate items in the option string
*       GETFUN - Allocate a Fortran unit number
*       LENSTR - Find the length of a character string
*       RQUOTE - Copy a string, removing outer quotes
*       TRNNAM - Translate a logical name
*       VTVECT - Draw a vector on a ReGIS display
*
*
* AUTHOR / MAINTAINED BY:
*       P. Kabal
*
*
* DATE CREATED:
*       1984/03/21
*
*
* UPDATES:
*       1984/03/12  Reset coordinate memory in VTCOM
*       1986/06/14  Clear/Overlay changes
*       1988/12/12  Change in file name defaults
*       1990/03/01  New common area
*
*
*---------------------------INRS-Telecommunications---------------------------

        SUBROUTINE VTINIT (OPTION)


        CHARACTER*(*) ERASE
        INTEGER DARK,ESC,NEKEY
        PARAMETER (DARK=0,ESC=27,ERASE='S(E)')
        PARAMETER (NEKEY=3)

        INTEGER NC,N,NCN
        INTEGER LENSTR

        CHARACTER*(*) OPTION
        CHARACTER*256 LINE,TOKEN
        CHARACTER*20 KEYTAB(NEKEY)
        CHARACTER*1 CESC

        LOGICAL CLEAR

        INTEGER LUNVT
        CHARACTER*255 FNAMVT
        COMMON /VTCOM/ LUNVT,FNAMVT
        DATA LUNVT/-1/,FNAMVT/' '/

        DATA KEYTAB/'CL*EAR'         , 'OVER*LAY'        ,
     -              'FILE*NAME'      /


        CLEAR=(LUNVT.LT.0)
        CALL RQUOTE(OPTION,LINE,NC)

* Decode the options
100     IF (LENSTR(LINE).GT.0) THEN
          CALL FNDPAR(LINE,KEYTAB,NEKEY,TOKEN,NC,N)

          IF (N.EQ.1) THEN
            CLEAR=.TRUE.

          ELSE IF (N.EQ.2) THEN
            CLEAR=.FALSE.

          ELSE IF (N.EQ.3) THEN
            CALL RQUOTE(TOKEN(1:NC),FNAMVT,NCN)

          END IF

        GO TO 100
        END IF


        IF (LUNVT.LT.0) THEN

* Not previously selected
* Resolve the file name
          IF (LENSTR(FNAMVT).LE.0) THEN
            CALL TRNNAM('VTPLOT',FNAMVT,NCN)
            IF (NCN.LT.0) THEN
              FNAMVT='TT'
            ELSE
              FNAMVT='VTPLOT'
            END IF
          END IF

* Open the file
          CALL GETFUN(LUNVT)
          OPEN (UNIT=LUNVT,FILE=FNAMVT,STATUS='NEW',
     -          CARRIAGECONTROL='LIST')

          CESC=CHAR(ESC)
          WRITE (UNIT=LUNVT,FMT=1000) CESC//'P'//
     -                                '1pS(A[0,0][799,479])'
          IF (CLEAR) WRITE (UNIT=LUNVT,FMT=1000) ERASE
          CALL VTVECT(LUNVT,0,0,0)

        ELSE IF (CLEAR) THEN

* Previously selected, with CLEAR option
          WRITE (UNIT=LUNVT,FMT=1000) ERASE

        END IF


        RETURN

1000    FORMAT (A)

        END
