*---------------------------INRS-Telecommunications---------------------------
*
*
* MODULE:
*       SUBROUTINE VTEND
*
*
* PURPOSE:
*       This subroutine terminates a plot on a ReGIS terminal.
*
*
* DESCRIPTION:
*       This subroutine exits ReGIS mode with the text cursor placed
*       at the home position. The routine then closes the plotting unit.
*
*
* PARAMETERS:
*       None
*
*
* ROUTINES REQUIRED:
*       RELFUN - Release a unit number
*
*
* AUTHOR / MAINTAINED BY:
*       D. Sloan / P. Kabal
*
*
* DATE CREATED:
*       1984/21/17
*
*
* UPDATES:
*       1990/03/01  New common area
*
*
*---------------------------INRS-Telecommunications---------------------------

        SUBROUTINE VTEND


        INTEGER ESC,BSLASH
        PARAMETER (ESC=27,BSLASH=92)

        CHARACTER*1 CESC,CBSL

        INTEGER LUNVT
        CHARACTER*255 FNAMVT
        COMMON /VTCOM/ LUNVT,FNAMVT


* Exit Regis
        CESC=CHAR(ESC)
        CBSL=CHAR(BSLASH)
        WRITE (UNIT=LUNVT,FMT=1000) CESC//CBSL//CESC//'8'

* Close the unit
        CLOSE (UNIT=LUNVT)
        CALL RELFUN(LUNVT)

* Set the common area parameters to their default values
        LUNVT=-1
        FNAMVT=' '

        RETURN

1000    FORMAT (A)

        END
