*--------------------------INRS-Telecommunications---------------------------
*
*
* MODULE:
*	SUBROUTINE QPRINT (FNAME, QNAME, FORM, DELF, NOTF)
*
*
* PURPOSE:
*	This routine queues a print job to a specified queue.
*
*
* DESCRIPTION:
*	This routine queues a print job. The form to be used, and the
*	delete and notify flags can be specified.
*
*
* PARAMETERS:
* ->	FNAME  - File name
* ->	QNAME  - Queue name. A null string gives SYS$PRINT.
* ->	FORM   - Character string specifying the form to be used,
*	         A null string gives the default form.
* ->	DELF   - Logical value. DELF should be set to .TRUE. if the
*	         file is to be deleted after printing.
* ->	NOTF   - Logical value. NOTF should be set to .TRUE. if the
*	         notification of print job status is to be broadcase
*	         to the caller.
*
* ROUTINES REQUIRED:
*	LENSTR - Find the length of a string
*	LIB$SIGNAL - Signal an error condition
*	MESS   - Write a message
*	SYS$SNDJBCW - System routine to queue a job
*
*
* AUTHOR / MAINTAINED BY:
*	P. Kabal
*
*
* DATE CREATED:
*	89/04/03
*
*
* UPDATES:
*
*
*--------------------------INRS-Telecommunications---------------------------

	SUBROUTINE QPRINT (FNAME, QNAME, FORM, DELF, NOTF)


	INCLUDE '($SJCDEF)'

* Define item list and status block
	STRUCTURE /ITMLST/
	  UNION
	    MAP
	      INTEGER*2 BUFLEN,ITMCOD
	      INTEGER*4 BUFADR,RETADR
	    END MAP
	    MAP
	      INTEGER*4 END_LIST
	    END MAP
	  END UNION
	END STRUCTURE

	STRUCTURE /IOSBLK/
	  INTEGER*4 STS,ZEROED
	END STRUCTURE

	RECORD /ITMLST/ SUBMIT_LIST(7)
	RECORD /IOSBLK/ IOSB

	CHARACTER*(*) FNAME,QNAME,FORM
	CHARACTER*255 JOB_STATUS

	INTEGER*4 SYS$SNDJBCW,ISTAT

	INTEGER*2 NCJS

	LOGICAL NOTF,DELF


* Fill in the item list
	SUBMIT_LIST(1).BUFLEN=LENSTR(QNAME)
	SUBMIT_LIST(1).ITMCOD=SJC$_QUEUE
	SUBMIT_LIST(1).BUFADR=%LOC(QNAME)
	SUBMIT_LIST(1).RETADR=0

	SUBMIT_LIST(2).BUFLEN=LENSTR(FNAME)
	SUBMIT_LIST(2).ITMCOD=SJC$_FILE_SPECIFICATION
	SUBMIT_LIST(2).BUFADR=%LOC(FNAME)
	SUBMIT_LIST(2).RETADR=0

	SUBMIT_LIST(3).BUFLEN=0
	IF (NOTF) THEN
	  SUBMIT_LIST(3).ITMCOD=SJC$_NOTIFY
	ELSE
	  SUBMIT_LIST(3).ITMCOD=SJC$_NO_NOTIFY
	END IF
	SUBMIT_LIST(3).BUFADR=0
	SUBMIT_LIST(3).RETADR=0

	SUBMIT_LIST(4).BUFLEN=0
	IF (DELF) THEN
	  SUBMIT_LIST(4).ITMCOD=SJC$_DELETE_FILE
	ELSE
	  SUBMIT_LIST(4).ITMCOD=SJC$_NO_DELETE_FILE
	END IF
	SUBMIT_LIST(4).BUFADR=0
	SUBMIT_LIST(4).RETADR=0

	SUBMIT_LIST(5).BUFLEN=LEN(JOB_STATUS)
	SUBMIT_LIST(5).ITMCOD=SJC$_JOB_STATUS_OUTPUT
	SUBMIT_LIST(5).BUFADR=%LOC(JOB_STATUS)
	SUBMIT_LIST(5).RETADR=%LOC(NCJS)

	IF (LENSTR(FORM).GT.0) THEN
	  SUBMIT_LIST(6).BUFLEN=LENSTR(FORM)
	  SUBMIT_LIST(6).ITMCOD=SJC$_FORM_NAME
	  SUBMIT_LIST(6).BUFADR=%LOC(FORM)
	  SUBMIT_LIST(6).RETADR=0
	  NITEM=6
	ELSE
	  NITEM=5
	END IF

	SUBMIT_LIST(NITEM+1).END_LIST=0

* Call the system service
	ISTAT=SYS$SNDJBCW(,%VAL(SJC$_ENTER_FILE),,SUBMIT_LIST,IOSB,,)
	IF (ISTAT) ISTAT=IOSB.STS

	IF (.NOT.ISTAT) CALL LIB$SIGNAL(%VAL(ISTAT))

	IF (NOTF) THEN
	  CALL MESS(JOB_STATUS(1:NCJS))
	END IF


	RETURN

	END
