*---------------------------INRS-Telecommunications---------------------------
*
*
* MODULE:
*       SUBROUTINE PSINIT (OPTION)
*
*
* PURPOSE:
*       This subroutine is used to perform initialization for a
*       Postscript plot file.
*
*
* DESCRIPTION:
*       This subroutine opens an encapsulated Postscript plot file. A
*       standard header is written to the file. This header sets up the
*       plot scaling to map the plotting coordinates (in the range 0 to
*       4095) to give 600 plotting units per inch. The header also
*       defines macros to draw lines and move the current location.
*       The resulting Postscript file can optionally be submitted for
*       printing on a Postscript printer. In this case, the file is
*       deleted after printing.
*
*
* PARAMETERS:
* C ->    OPTION - Character string specifying the options. Options are
*                separated by commas. If any option is omitted, the
*                default value is used. The same keyword may appear more
*                than once, with the last instance taking precedence.
*                FILENAME=name - Specifies the name of the file to which
*                  plot data is sent. The file name is not used if this
*                  plot device is already active. The default file name
*                  is the logical name PSPLOT if the logical name PSPLOT
*                  is defined. If the logical name PSPLOT is not defined
*                  and the filename is not specified, the default
*                  filename is derived from the name of the image
*                  (xxx.EPSF where xxx is the image name).
*                QUEUE_NAME=name - Specifies the name of the queue to be
*                  used to print the Postscript file. The queue name is
*                  set only when this plot device is first selected. The
*                  queue name is used only if the PRINT option is
*                  selected. The default queue name is LW$PRINT.
*                PRINT or NOPRINT - Specifies whether the Postscript
*                  file is to be queued for printing. The default is
*                  PRINT for device LW and NOPRINT for device PS.
*
*
* ROUTINES REQUIRED:
*       FNDPAR - Separate items in the option string
*       GETFUN - Allocate a Fortran unit number
*       GETIMG - Get the image name
*       LENSTR - Find the length of a character string
*       PSHEAD - Write Postscript header text
*       RQUOTE - Copy a string, removing outer quotes
*       TRNNAM - Translate a logical name
*
*
* AUTHOR / MAINTAINED BY:
*       P. Kabal
*
*
* DATE CREATED:
*       1988/01/15
*
*
* UPDATES:
*       1988/12/09  VMS file open
*       1989/04/04  Optionally print the file
*       1989/11/12  Use STREAM_LF files (more compact)
*       1990/03/04  New common area
*
*
*---------------------------INRS-Telecommunications---------------------------

        SUBROUTINE PSINIT (OPTION)


        INTEGER NEKEY
        PARAMETER (NEKEY=4)

        INTEGER NC,N,NCN
        INTEGER LENSTR

        CHARACTER*(*) OPTION
        CHARACTER*256 LINE,TOKEN
        CHARACTER*255 IMAGNM
        CHARACTER*20 KEYTAB(NEKEY)

        INTEGER LUNPS,IPRTPS
        CHARACTER*255 FNAMPS,QNAMPS
        COMMON /PSCOM/ LUNPS,IPRTPS,FNAMPS,QNAMPS
        DATA LUNPS/-1/,FNAMPS/' '/,QNAMPS/'LW$PRINT'/

        DATA KEYTAB/'FILE*NAME'      , 'QUEUE*_NAME'     ,
     -              'PRINT'          , 'NOPRINT'         /


        CALL RQUOTE(OPTION,LINE,NC)

* Decode the options
100     IF (LENSTR(LINE).GT.0) THEN
          CALL FNDPAR(LINE,KEYTAB,NEKEY,TOKEN,NC,N)

          IF (N.EQ.1) THEN
            CALL RQUOTE(TOKEN(1:NC),FNAMPS,NCN)

          ELSE IF (N.EQ.2) THEN
            CALL RQUOTE(TOKEN(1:NC),QNAMPS,NCN)

          ELSE IF (N.EQ.3) THEN
            IPRTPS=1

          ELSE IF (N.EQ.4) THEN
            IPRTPS=0

          END IF

        GO TO 100
        END IF


        IF (LUNPS.LT.0) THEN

* Not previously selected
          IF (FNAMPS.EQ.' ') THEN
            CALL TRNNAM('PSPLOT',FNAMPS,NCN)
            IF (NCN.LT.0) THEN
              CALL GETIMG(IMAGNM,NC)
              FNAMPS=IMAGNM(1:NC)//'.epsf'
            ELSE
              FNAMPS='PSPLOT'
            END IF
          END IF

* Open the file
          CALL GETFUN(LUNPS)
          OPEN (UNIT=LUNPS,FILE=FNAMPS,STATUS='NEW',
     -          CARRIAGECONTROL='LIST',RECORDTYPE='STREAM_LF')

          CALL PSHEAD(LUNPS)

        END IF


        RETURN

        END
