*---------------------------INRS-Telecommunications---------------------------
*
*
* MODULE:
*       SUBROUTINE PSEND
*
*
* PURPOSE:
*       This routine closes a Postscript plot file.
*
*
* DESCRIPTION:
*       This routine closes and optionally prints a Postscript plot file.
*
*
* PARAMETERS:
*       None
*
*
* ROUTINES REQUIRED:
*       PSTAIL - Write a trailer to a Postscript plot file
*       PSXY   - Postscript vector
*       QPRINT - Queue a file for printing
*       RELFUN - Release a Fortran unit number
*
*
* AUTHOR / MAINTAINED BY:
*       P. Kabal
*
*
* DATE CREATED:
*       1988/01/15
*
*
* UPDATES:
*       1989/04/04  Optionally print the file
*       1989/11/12  Push out buffered vectors
*       1990/03/04  New common area
*
*
*---------------------------INRS-Telecommunications---------------------------

        SUBROUTINE PSEND


        INTEGER LUNPS,IPRTPS
        CHARACTER*255 FNAMPS,QNAMPS
        COMMON /PSCOM/ LUNPS,IPRTPS,FNAMPS,QNAMPS


* Force any buffered plot vectors to be written
        CALL PSXY(0,0,0)

* Write a trailer to the file
        CALL PSTAIL(LUNPS)

* Close the Postscript plot file
        CLOSE (UNIT=LUNPS)
        CALL RELFUN(LUNPS)

* Queue the file for printing (default form, notify, delete)
        IF (IPRTPS.NE.0)
     -    CALL QPRINT(FNAMPS,QNAMPS,' ',.TRUE.,.TRUE.)

* Set the common area parameters to their default values
        LUNPS=-1
        IPRTPS=0
        FNAMPS=' '
        QNAMPS='LW$PRINT'

        RETURN


        END
