*---------------------------INRS-Telecommunications---------------------------
*
*
* MODULE:
*	SUBROUTINE PFGETP (FNAME, PLTOPT, PLTDEV, DEVOPT, IPLOT, IFAXIS,
*	                   SFREQ, XMIN, XMAX, XSPEC,
*	                   YMIN, YMAX, YSPEC, LABELS, TITLES, TSTR)
*
*
* PURPOSE:
*	This routine reads the parameters for a filter response plot.
*
*
* DESCRIPTION:
*	This routine reads the parameters for a filter response plot.
*	The command line parameters are as follows.
*	File_name - Coefficient file name.
*	Plotting_Device: The plotting device.
*	Qualifiers:
*       /AMPLITUDE_RESPONSE - IPLOT=1
*	/DB_AMPLITUDE_RESPONSE - IPLOT=2
*	/LOG_AMPLITUDE_RESPONSE - IPLOT=3
*	/DELAY_RESPONSE - IPLOT=4
*	/PHASE_RESPONSE - IPLOT=5
*	/RADIAN_PHASE_RESPONSE - IPLOT=6
*	/IMPULSE_RESPONSE - IPLOT=7
*	/X_LIMITS=(Xmin,Xmax) - XMIN,XMAX,XSPEC=.TRUE.
*	/Y_LIMITS=(Ymin,Ymax) - YMIN,YMAX,YSPEC=.TRUE.
*	/LOG_FREQUENCY - IFAXIS=1 or 3
*	/RADIAN_FREQUENCY - IFAXIS=2 or 3
*	/NOLOG_FREQUENCY
*	/NORADIAN_FREQUENCY
*	/SAMPLING_FREQUENCY=SFreq - SFREQ
*	/LABELS or /NOLABELS - LABELS=.TRUE. or LABELS=.FALSE.
*	/TITLES="title_string", or /TITLES or /NOTITLES - TITLES=.TRUE.
*	    or TITLES=.FALSE. and TSTR='title_string'
*	/OPTIONS="options_string" - Plot device or plotting options,
*	   depending on the placement of the qualifier. If this
*	   qualifier is placed after the filter file name, the option
*	   string is passed as part of the string PLTOPT. If this
*	   qualifier is placed after the plot device, the option
*	   string is passed as part of the string DEVOPT.
*
*
* PARAMETERS:
*   (*)	FNAME  - Coefficient file name
*   (*)	PLTOPT - Plot option string
*   (*)	PLTDEV - Plot device string
*   (*)	DEVOPT - Device option string
*   (*)	IPLOT  - Type of plot,
*	         1 - linear amplitude
*	         2 - dB amplitude
*	         3 - log amplitude
*	         4 - group delay
*	         5 - phase response
*	         6 - radian phase
*	         7 - impulse response
*   (*) IFAXIS - Frequency axis option
*	         0 - linear frequency (Hz)
*	         1 - log frequency (Hz)
*	         2 - linear radian frequency
*	         3 - log radian frequency
*   (*)	SFREQ  - Sampling frequency (SFREQ=-1 if not specified)
*   (*)	XMIN   - Minimum abscissa value. For frequency plots, XMIN
*	         and XMAX are in Hz.
*   (*)	XMAX   - Maximum abscissa value
*   (*)	XSPEC  - Logical flag,
*	           .FALSE. - XMIN and XMAX not set
*	           .TRUE.  - XMIN and XMAX set
*   (*)	YMIN   - Minimum ordinate value
*   (*)	YMAX   - Maximum ordinate value
*   (*)	YSPEC  - Logical flag,
*	           .FALSE. - YMIN and YMAX not set
*	           .TRUE.  - YMIN and YMAX set
*   (*)	LABELS - Logical variable, .TRUE. if labels have been selected
*   (*)	TITLES - Logical variable, .TRUE. if titles have been selected
*   (*)	TSTR   - Title string (terminated by a null character)
*
*
* ROUTINES REQUIRED:
*	CLI$GET_VALUE - Retrieve a command line value
*	CLI$PRESENT - Check for a command line item
*	CONSTR - Concatenate strings
*	GETVALUELIST - Get a list of values
*	HALT   - Signal an error condition
*	RDRVA1 - Read a real value
*	RDRVA2 - Read real values
*	STCOPY - Copy a string
*
*
* AUTHOR / MAINTAINED BY:
*	P. Kabal
*
*
* DATE CREATED:
*	86/06/18  PLTFILTER
*
*
* UPDATES:
*	88/04/29  Separated from PLTFILTER
*	89/12/08  Option handling changed
*
*	
*---------------------------INRS-Telecommunications---------------------------

	SUBROUTINE PFGETP (FNAME, PLTOPT, PLTDEV, DEVOPT, IPLOT, IFAXIS,
     -	                   SFREQ, XMIN, XMAX, XSPEC,
     -	                   YMIN, YMAX, YSPEC, LABELS, TITLES, TSTR)


	INTEGER LINS,LOGS,CFREQ,RFREQ
	PARAMETER (LINS=0,LOGS=1,CFREQ=0,RFREQ=1)
	INTEGER LINAR,DBAR,LOGAR,DELYR,PHASD,PHASR,IMPLR
	PARAMETER (LINAR=1,DBAR=2,LOGAR=3,DELYR=4,PHASD=5,PHASR=6,
     -	           IMPLR=7)

	CHARACTER*(*) FNAME,PLTOPT,PLTDEV,DEVOPT,TSTR
	CHARACTER*255 VALUE

	INTEGER CLI$GET_VALUE,CLI$PRESENT

	LOGICAL XSPEC,YSPEC,LABELS,TITLES

	EXTERNAL CLI$_ABSENT,CLI$_PRESENT,CLI$_NEGATED


*==========
* Dump the global OPTION string
	ISTAT=CLI$GET_VALUE('OPTION',VALUE,NC)
	IF (ISTAT.NE.%LOC(CLI$_ABSENT))
     -	  CALL HALT('PFGETP - /OPTION must follow parameters')

* Get the input file name
	CALL CLI$GET_VALUE('INFILE',FNAME)

* Get the plot OPTION string
	PLTOPT=' '
	ISTAT=CLI$GET_VALUE('OPTION',VALUE,NC)
	IF (ISTAT.NE.%LOC(CLI$_ABSENT))
     -	  CALL STCOPY(VALUE(1:NC),PLTOPT,NNC)

* Get the plot device
	CALL CLI$GET_VALUE('DEVICE',PLTDEV)

* Get the local OPTION string following the plot device
	ISTAT=CLI$GET_VALUE('OPTION',VALUE,NC)
	IF (ISTAT.NE.%LOC(CLI$_ABSENT))
     -	  CALL STCOPY(VALUE(1:NC),DEVOPT,NNC)

* Pick up the qualifiers
	IF (CLI$PRESENT('AMPLITUDE_RESPONSE').EQ.
     -	    %LOC(CLI$_PRESENT)) THEN
	  IPLOT=LINAR
	ELSE IF (CLI$PRESENT('LOG_AMPLITUDE_RESPONSE').EQ.
     -	    %LOC(CLI$_PRESENT)) THEN
	  IPLOT=LOGAR
	ELSE IF (CLI$PRESENT('DELAY_RESPONSE').EQ.
     -	         %LOC(CLI$_PRESENT)) THEN
	  IPLOT=DELYR
	ELSE IF (CLI$PRESENT('PHASE_RESPONSE').EQ.
     -	         %LOC(CLI$_PRESENT)) THEN
	  IPLOT=PHASD
	ELSE IF (CLI$PRESENT('RADIAN_PHASE_RESPONSE').EQ.
     -	         %LOC(CLI$_PRESENT)) THEN
	  IPLOT=PHASR
	ELSE IF (CLI$PRESENT('IMPULSE_RESPONSE').EQ.
     -	         %LOC(CLI$_PRESENT)) THEN
	  IPLOT=IMPLR
	ELSE
	  IPLOT=DBAR
	END IF

* Sampling frequency
	SFREQ=-1.0
	ISTATUS=CLI$GET_VALUE('SAMPLING_FREQUENCY',VALUE)
	IF (ISTATUS.NE.%LOC(CLI$_ABSENT)) THEN
	  CALL RDRVA1(VALUE,SFREQ,IER)
	  IF (IER.NE.0 .OR. SFREQ.LE.0.0)
     -	     CALL HALT('PFGETP - Invalid sampling frequency')
	END IF

* X range
	CALL GETVALUELIST('X_LIMITS',VALUE,NC)
	IF (NC.GT.0) THEN
	  CALL RDRVA2(VALUE,XMIN,XMAX,IER)
	  IF (IER.NE.0) CALL HALT('PFGETP - Invalid X_LIMITS specification')
	  XSPEC=.TRUE.
	ELSE
	  XSPEC=.FALSE.
	END IF

* Amplitude range
	CALL GETVALUELIST('Y_LIMITS',VALUE,NC)
	IF (NC.GT.0) THEN
	  CALL RDRVA2(VALUE,YMIN,YMAX,IER)
	  IF (IER.NE.0) CALL HALT('PFGETP - Invalid Y_LIMITS specification')
	  YSPEC=.TRUE.
	ELSE
	  YSPEC=.FALSE.
	END IF

* Log frequency option
	ISTATUS=CLI$PRESENT('LOG_FREQUENCY')
	IF (ISTATUS.EQ.%LOC(CLI$_PRESENT)) THEN
	  ILOG=LOGS
	ELSE
	  ILOG=LINS
	END IF

* Radian frequency option
	ISTATUS=CLI$PRESENT('RADIAN_FREQUENCY')
	IF (ISTATUS.EQ.%LOC(CLI$_PRESENT)) THEN
	  IRAD=RFREQ
	ELSE
	  IRAD=CFREQ
	END IF

* Labels option
	ISTATUS=CLI$PRESENT('LABELS')
	LABELS=.NOT.(ISTATUS.EQ.%LOC(CLI$_NEGATED))

* Titles option
	ISTATUS=CLI$PRESENT('TITLES')
	TITLES=.NOT.(ISTATUS.EQ.%LOC(CLI$_NEGATED))
	CALL CLI$GET_VALUE('TITLES',TSTR,NC)
	IF (NC.LT.LEN(TSTR)) TSTR(NC+1:NC+1)=CHAR(0)

* Error checks
	IF (IPLOT.EQ.IMPLR) THEN
	  IF (ILOG.EQ.LOGS)
     -	    CALL WARN('PFGETP - Log frequency option '//
     -	              'incompatible with impulse response')
	  IF (IRAD.EQ.RFREQ)
     -	    CALL WARN('PFGETP - Radian frequency option '//
     -	              'incompatible with impulse response')
	END IF

* Convert radian limits to Hz
	IF (XSPEC .AND. IRAD.EQ.RFREQ) THEN
	  XMIN=0.5*XMIN
	  XMAX=0.5*XMAX
	END IF

* Return the frequency axis option
	IFAXIS=ILOG+2*IRAD


	RETURN

	END
