*---------------------------INRS-Telecommunications---------------------------
*
*
* MODULE:
*	SUBROUTINE GETVALUELIST (QUALIFIER, VALUELIST, NC)
*
*
* PURPOSE:
*	This subroutine gets a list of values corresponding to a qualifier.
*
*
* DESCRIPTION:
*	This subroutine returns a list of values associated with a qualifier.
*	It uses the system subroutine CLI$GET_VALUE to get individual values
*	associated with a given qualifier. These items are combined into
*	a list, with the items separated by commas.
*
*
* PARAMETERS:
*	QUALIFIER - Qualifier name
*   (*)	VALUELIST - List of values, with items separated by commas
*   (*)	NC        - Number of characters in VALUELIST. NC is zero if
*	            there was no list
*
*
* ROUTINES REQUIRED:
*	CLI$GET_VALUE - Get a value associated with a qualifier
*	CONSTR - Concatenate strings separated by a delimiter
*	HALT - Signal an error and stop
*	LENSTR - Length of a string
*	LIB$STOP - Signal an error and stop
*
*
* AUTHOR / MAINTAINED BY:
*	P. Kabal
*
*
* DATE CREATED:
*	86/10/13
*
*
* UPDATES:
*
*
*---------------------------INRS-Telecommunications---------------------------

	SUBROUTINE GETVALUELIST (QUALIFIER, VALUELIST, NC)


	INTEGER CLI$GET_VALUE

	CHARACTER*(*) QUALIFIER, VALUELIST
	CHARACTER*255 VALUE

	EXTERNAL CLI$_ABSENT,CLI$_COMMA,CLI$_CONCAT,SS$_NORMAL


	VALUELIST=' '
	ISTATUS=CLI$GET_VALUE(QUALIFIER,VALUE,N)

* CLI$GET_VALUE returns CLI$_COMMA when the delimiter is a comma and
* SS$_NORMAL for the last value
	DO WHILE (ISTATUS.EQ.%LOC(CLI$_COMMA) .OR.
     -	          ISTATUS.EQ.%LOC(SS$_NORMAL))
	  CALL CONSTR(VALUELIST,',',VALUE(1:N),VALUELIST)
	  ISTATUS=CLI$GET_VALUE(QUALIFIER,VALUE,N)
	END DO
	IF (ISTATUS.EQ.%LOC(CLI$_CONCAT))
     -	  CALL HALT ('GETVALUELIST - Invalid list of values')

* Signal unknown errors
	IF (ISTATUS.NE.%LOC(CLI$_ABSENT)) CALL LIB$STOP(%LOC(ISTATUS))

	NC=LENSTR(VALUELIST)


	RETURN

	END
