*---------------------------INRS-Telecommunications---------------------------
*
*
* MODULE:
*	SUBROUTINE GETDAT (DATTIM)
*
*
* PURPOSE:
*	This routine returns the date as a string.
*
*
* DESCRIPTION:
*	This routine returns a string containing the date and time.
*	The format of the returned string depends on the length of
*	the string.
*	  20 characters or more:
*	    11-May-1988 13:55:45
*	  17-19 characters:
*	    11-May-1988 13:55
*	  11-18 characters:
*	    11-May-1988
*
*
* PARAMETERS:
* C <-	DATTIM - Output character string containing the date and
*	         time. The full length string is 20 characters long.
*
*
* ROUTINES REQUIRED:
*	DATE   - System routine to return the date
*	KEYUPC - Keyword match
*	TIME   - System routine to return the time
*	WARN   - Signal a warning message
*
*
* AUTHOR / MAINTAINED BY:
*	P. Kabal
*
*
* DATE CREATED:
*	1988/08/01
*
*
* UPDATES:
*
*
*---------------------------INRS-Telecommunications---------------------------

	SUBROUTINE GETDAT (DATTIM)


	CHARACTER*(*) DATTIM
	CHARACTER*20 STIME
	CHARACTER*3 MONTAB(12),MLCTAB(12)

	DATA MONTAB/
     -	  'JAN', 'FEB', 'MAR', 'APR', 'MAY', 'JUN',
     -	  'JUL', 'AUG', 'SEP', 'OCT', 'NOV', 'DEC'/
	DATA MLCTAB/
     -	  'Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',
     -	  'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'/


* Get the date and time
	CALL DATE(STIME)
	STIME(10:11)=STIME(8:9)
	STIME(8:9)='19'
	STIME(12:12)=' '
	CALL TIME(STIME(13:))
	N=KEYUPC(STIME(4:6),MONTAB,12)
	IF (N.EQ.0) THEN
	  CALL WARN('GETDAT - Invalid month abbreviation')
	ELSE
	  STIME(4:6)=MLCTAB(N)
	END IF

* Selectively leave out parts of the date/time
	LEND=LEN(DATTIM)
	IF (LEND.GE.20) THEN
	  DATTIM=STIME
	ELSE IF (LEND.GE.17) THEN
	  DATTIM=STIME(1:17)
	ELSE IF (LEND.GE.11) THEN
	  DATTIM=STIME(1:11)
	ELSE
	  DATTIM=STIME(1:11)
	  CALL WARN('GETDAT - Output string truncated')
	END IF


	RETURN

	END
