*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE PLTLIM (VMIN, VMAX, ILL, IUL, ILOG, DMIN, DMAX)
*
*
* Purpose:
*     Find plot limits for a range of data values
*
*
* Description:
*     This routine chooses plot limits suitable for plotting a range of
*     data.
*
*
* Parameters:
* R ->  VMIN   - Minimum data value
* R ->  VMAX   - Maximum data value
* I ->  ILL    - Lower limit options,
*                1 - The lower limit is to be a tick value less than or
*                    equal to VMIN
*                2 - The lower limit is VMIN
* I ->  IUL    - Upper limit options,
*                1 - The upper limit is to be a tick value greater than
*                    or equal to VMAX
*                2 - The upper limit is VMAX
* I ->  ILOG   - Linear/log axis option,
*                0 - linear axis
*                1 - log axis
* R <-  DMIN   - Lower limit
* R <-  DMAX   - Upper limit
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.6 $  $Date: 1995/03/08 15:46:44 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE PLTLIM (VMIN, VMAX, ILL, IUL, ILOG, DMIN, DMAX)


      INTEGER MXTICK
      PARAMETER (MXTICK=64)

      INTEGER ILL,IUL,ILOG
      INTEGER IAX,NTICK,IEXP

      REAL VMIN,VMAX,DMIN,DMAX
      REAL ATICK(MXTICK)

      CHARACTER*11 ALABEL(MXTICK)


* Call AXSCAL to determine DMIN and DMAX
      IAX=ILL+4*IUL+64*ILOG
      CALL AXSCAL(VMIN,VMAX,IAX,DMIN,DMAX,ATICK,ALABEL,NTICK,IEXP)


      RETURN

      END
