*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE PFSETY (IPLOT, FLTTYP, H, NCOF, SFREQ, X, Y, NPT)
*
*
* Purpose:
*     Set the array of ordinate values for a filter response
*
*
* Description:
*     This routine sets the Y-array for a filter response plot.
*
*
* Parameters:
* I ->  IPLOT  - Type of plot,
*                1 - linear amplitude
*                2 - dB amplitude
*                3 - log amplitude
*                4 - group delay
*                5 - phase response
*                6 - radian phase
*                7 - impulse response
* C ->  FLTTYP - Character string indicating the type of filter,
*                ALL - all-pole filter
*                CAS - cascade analog filter
*                FIR - finite impulse response filter
*                IIR - infinite impulse response filter
*                WIN - window response
* R ->  H      - Array of filter coefficients
* I ->  NCOF   - Number of filter coefficients
* R ->  SFREQ  - Sampling frequency
* R ->  X      - Input array of abscissa values at which the response
*                is to be calculated
* R <-  Y      - Output array of response values
* I ->  NPT    - Number of abscissa and response values
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.7 $  $Date: 1995/03/08 15:46:25 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE PFSETY (IPLOT, FLTTYP, H, NCOF, SFREQ, X, Y, NPT)


      INTEGER LINAR,DBAR,LOGAR,DELYR,PHASD,PHASR,IMPLR
      PARAMETER (LINAR=1,DBAR=2,LOGAR=3,DELYR=4,PHASD=5,PHASR=6,
     -           IMPLR=7)
      REAL PI
      PARAMETER (PI=3.141 592 654)

      INTEGER IPLOT,NCOF,NPT
      INTEGER IST

      CHARACTER*(*) FLTTYP

      REAL H(0:NCOF-1),X(0:NPT-1),Y(0:NPT-1)
      REAL SFREQ

      EXTERNAL FMAGRP,GDELRP,PHASRP
      REAL FMAGRP,GDELRP,PHASRP

* All-pole filter warning message
      IF (FLTTYP.EQ.'ALL' .AND. H(0).NE.1.0)
     -    CALL WARN('PFSETY - Non-unity first coefficient')

* Calculate the frequency response
      IF (IPLOT.EQ.LINAR .OR. IPLOT.EQ.LOGAR .OR. IPLOT.EQ.DBAR) THEN
        CALL FRRESP(X,Y,NPT,H,NCOF,FLTTYP,SFREQ,FMAGRP)
        IF (IPLOT.EQ.DBAR) CALL VDBV(Y,Y,NPT)

* Calculate the group delay
      ELSE IF (IPLOT.EQ.DELYR) THEN
        CALL FRRESP(X,Y,NPT,H,NCOF,FLTTYP,SFREQ,GDELRP)

* Calculate the phase response
      ELSE IF (IPLOT.EQ.PHASD .OR. IPLOT.EQ.PHASR) THEN
        CALL FRRESP(X,Y,NPT,H,NCOF,FLTTYP,SFREQ,PHASRP)
        IF (IPLOT.EQ.PHASD) THEN
          CALL VSMULN(Y,180./PI,Y,NPT)
        ELSE
          CALL VSMULN(Y,1./PI,Y,NPT)
        END IF

* Calculate the impulse response
      ELSE IF (IPLOT.EQ.IMPLR) THEN
        IST=NINT(X(0)*SFREQ)
        CALL IMPLRP(H,NCOF,FLTTYP,IST,Y,NPT)

* Unknown plot option
      ELSE
        CALL HALT('PFSETY - Invalid plot option')

      END IF


      RETURN

      END
