*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE PFILIM (SFREQ, Y, NPT, EPS, XMAX)
*
*
* Purpose:
*     Find the extent of a response to be plotted
*
*
* Description:
*     This routine finds the extent of a response.  The extent is
*     determined to be that part of the response (starting at zero)
*     beyond which all samples habe a magnitude smaller than EPS times
*     the largest response value.  The plotting limits which include
*     this extent are returned.
*
*
* Parameters:
* R ->  SFREQ  - Sampling frequency
* R ->  Y      - Array of response values
* I <-> NPT    - Number of response values.  This is both an input and
*                an output variable.  On input it specified the number
*                of response values available.  On output it is set to
*                a value between 2 and its previous value (inclusive),
*                based on the extent of the significant part of the
*                response.
* R ->  EPS    - Tolerance value.  The extent of the response is
*                determined to include samples which are larger than
*                EPS times the largest magnitude sample.
* R <-  XMAX   - Maximum abscissa value, set to the extent of the
*                response to be plotted
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.7 $  $Date: 1995/03/08 15:46:18 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE PFILIM (SFREQ, Y, NPT, EPS, XMAX)


      INTEGER TICKV,EXACTV,LINS
      PARAMETER (TICKV=1,EXACTV=2,LINS=0)

      INTEGER NPT
      INTEGER IL,IU,NP
      INTEGER ICEILX

      REAL Y(0:*)
      REAL SFREQ,EPS,XMAX
      REAL TMIN,TMAX,TAB,XMIN


* Find the extent of the impulse response
      CALL MINMAX(Y,NPT,TMIN,TMAX)
      TAB=MAX(ABS(TMIN),ABS(TMAX))
      CALL VEXTNT(Y,NPT,EPS*TAB,IL,IU)
      TMIN=0.0
      TMAX=(MAX(IU,2)-1)/SFREQ
      CALL PLTLIM(TMIN,TMAX,EXACTV,TICKV,LINS,XMIN,XMAX)

* Error check
      NP=ICEILX(XMAX*SFREQ)+1
      IF (NP.GT.NPT) THEN
        CALL WARN('PFILIM - Response truncated')
      ELSE
        NPT=NP
      END IF
      

      RETURN

      END
