*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE PFGETP (FNAME, PLTOPT, PLTDEV, DEVOPT, IPLOT, IFAXIS,
*                        SFREQ, XMIN, XMAX, XSPEC,
*                        YMIN, YMAX, YSPEC, LABELS, TITLES, TSTR)
*
*
* Purpose:
*     Get the filter response plot parameters
*
*
* Description:
*     This routine reads the parameters for a filter response plot.
*
*     % pltfilter Filename PlotDevice Options
*
*     If any of the arguments is missing, the program prompts for the
*     arguments.
*
*      AMP*LITUDE_RESPONSE
*      DB*_AMPLITUDE_RESPONSE
*      LOG*_AMPLITUDE_RESPONSE
*      DELAY*_RESPONSE
*      PHASE*_RESPONSE
*      RADIAN_PHASE*_RESPONSE
*      IMP*ULSE_RESPONSE
*      SAMP*LING_FREQUENCY=Sfreq
*      X*-LIMITS=(Xmin,Xmax)
*      Y*-LIMITS=(Ymin,Ymax)
*      LOG_FREQ*UENCY= null, ON or OFF
*      RADIAN_FREQ*UENCY=null, ON or OFF
*      LAB*ELS=null, ON or OFF
*      T*ITLE="title string" or OFF
*      DEVICE_OPT*TIONS="device option string"
*      PLOT_OPT*IONS="plot option string"
*
*
* Parameters:
* C <-  FNAME  - Coefficient file name
* C <-  PLTOPT - Plot option string, default ' '
* C <-  PLTDEV - Plot device string
* C <-  DEVOPT - Device option string, default ' '
* I <-  IPLOT  - Type of plot,
*                1 - linear amplitude
*                2 - dB amplitude (default)
*                3 - log amplitude
*                4 - group delay
*                5 - phase response
*                6 - radian phase
*                7 - impulse response
* I <-  IFAXIS - Frequency axis options,
*                0 - linear frequency (Hz) (default)
*                1 - log frequency (Hz)
*                2 - linear radian frequency
*                3 - log radian frequency
* R <-  SFREQ  - Sampling frequency (SFREQ=-1 if not specified)
* R <-  XMIN   - Minimum abscissa value.  For frequency plots, XMIN and
*                XMAX are in Hz.
* R <-  XMAX   - Maximum abscissa value
* L <-  XSPEC  - Logical flag,
*                  .FALSE. - XMIN and XMAX not set
*                  .TRUE.  - XMIN and XMAX set
* R <-  YMIN   - Minimum ordinate value
* R <-  YMAX   - Maximum ordinate value
* L <-  YSPEC  - Logical flag,
*                  .FALSE. - YMIN and YMAX not set
*                  .TRUE.  - YMIN and YMAX set
* L <-  LABELS - Logical variable, .TRUE. if labels have been selected
*                (default .TRUE.)
* L <-  TITLES - Logical variable, .TRUE. if titles have been selected
*                (default .FALSE.)
* C <-  TSTR   - Title string (terminated by a null character)
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:46:15 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE PFGETP (FNAME, PLTOPT, PLTDEV, DEVOPT, IPLOT, IFAXIS,
     -                   SFREQ, XMIN, XMAX, XSPEC,
     -                   YMIN, YMAX, YSPEC, LABELS, TITLES, TSTR)


      INTEGER LINS,LOGS,CFREQ,RFREQ
      PARAMETER (LINS=0,LOGS=1,CFREQ=0,RFREQ=1)
      INTEGER LINAR,DBAR,LOGAR,DELYR,PHASD,PHASR,IMPLR
      PARAMETER (LINAR=1,DBAR=2,LOGAR=3,DELYR=4,PHASD=5,PHASR=6,
     -           IMPLR=7)

      INTEGER IPLOT,IFAXIS
      INTEGER NARG,IA,IER,IEOF,ILOG,IRAD,NC,N,IT
      INTEGER IARGC,LENSTR,KEYUPC

      LOGICAL XSPEC,YSPEC,LABELS,TITLES

      CHARACTER*(*) FNAME,PLTOPT,PLTDEV,DEVOPT,TSTR
      CHARACTER*512 LINE,TOKEN

      REAL SFREQ,XMIN,XMAX,YMIN,YMAX

      CHARACTER*3 OFFTAB(1)
      DATA OFFTAB/'OFF'/

      INTEGER NEKEY
      PARAMETER (NEKEY=16)
      CHARACTER*23 KEYTAB(NEKEY)
      DATA KEYTAB/
     - 'AMP*LITUDE_RESPONSE',      'DB*_AMPLITUDE_RESPONSE',
     - 'LOG*_AMPLITUDE_RESPONSE',  'DELAY*_RESPONSE',
     - 'PHASE*_RESPONSE',          'RADIAN_PHASE*_RESPONSE',
     - 'IMP*ULSE_RESPONSE',        'SAMP*LING_FREQUENCY',
     - 'X*-LIMITS',                'Y*-LIMITS',
     - 'LOG_FREQ*UENCY',           'RADIAN_FREQ*UENCY',
     - 'T*ITLE',                   'DEVICE_OPT*IONS',
     - 'PLOT_OPT*IONS',            'LAB*ELS'/


* Default values
      FNAME=' '
      PLTDEV=' '
      IPLOT=DBAR
      SFREQ=-1.
      ILOG=LINS
      IRAD=CFREQ
      LABELS=.TRUE.
      TITLES=.TRUE.
      TSTR=CHAR(0)
      XSPEC=.FALSE.
      YSPEC=.FALSE.
      DEVOPT=' '
      PLTOPT=' '

* Try to get the file name and plot device from the command line
      NARG=IARGC()
      IF (NARG.GE.1) THEN
        CALL GETARG(1,FNAME)
      ELSE
        CALL LINEIN('Filename: ',FNAME,NC,IEOF)
        IF (NC.LE.0) GO TO 600
      END IF
      IF (NARG.GE.2) THEN
        CALL GETARG(2,PLTDEV)
      ELSE
        CALL LINEIN('Plot Device: ',PLTDEV,NC,IEOF)
        IF (NC.LE.0) GO TO 600
      END IF

      IA=3

* Read an option
 200  IF (NARG.GE.3) THEN
        IF (IA.GT.NARG) GO TO 600
        CALL GETARG(IA,LINE)
        IA=IA+1
      ELSE
        CALL LINEIN('Options: ',LINE,NC,IEOF)
        IF (NC.LE.0) GO TO 600
      END IF

* Decode the keyword items
 300  IF (LENSTR(LINE).GT.0) THEN
        CALL FNDPAR(LINE,KEYTAB,NEKEY,TOKEN,NC,N)

*** AMPLITUDE_RESPONSE
        IF (N.EQ.1) THEN
          IPLOT=LINAR

*** DB_AMPLITUDE_RESPONSE
        ELSE IF (N.EQ.2) THEN
          IPLOT=DBAR

*** LOG_AMPLITUDE_RESPONSE
        ELSE IF (N.EQ.3) THEN
          IPLOT=LOGAR

*** DELAY_RESPONSE
        ELSE IF (N.EQ.4) THEN
          IPLOT=DELYR

*** PHASE_RESPONSE
        ELSE IF (N.EQ.5) THEN
          IPLOT=PHASD

*** RADIAN_PHASE_RESPONSE
        ELSE IF (N.EQ.6) THEN
          IPLOT=PHASR

*** IMPULSE_RESPONSE
        ELSE IF (N.EQ.7) THEN
          IPLOT=IMPLR

*** SAMPLING_FREQUENCY
        ELSE IF (N.EQ.8) THEN
          CALL RDRVA1(TOKEN,SFREQ,IER)
          IF (IER.NE.0 .OR. SFREQ.LE.0.0)
     -        CALL WARN('PFGETP - Invalid sampling frequency')

* X-LIMITS
        ELSE IF (N.EQ.9) THEN
          CALL RDRVA2(TOKEN,XMIN,XMAX,IER)
          IF (IER.NE.0) THEN
            CALL WARN('PFGETP - Invalid X-LIMITS specification')
          ELSE
            XSPEC=.TRUE.
          END IF

* Y-LIMITS
        ELSE IF (N.EQ.10) THEN
          CALL RDRVA2(TOKEN,YMIN,YMAX,IER)
          IF (IER.NE.0) THEN
            CALL WARN('PFGETP - Invalid Y-LIMITS specification')
          ELSE
            YSPEC=.TRUE.
          END IF

*** LOG_FREQUENCY
        ELSE IF (N.EQ.11) THEN
          CALL DECOFF(TOKEN,ILOG)

*** RADIAN_FREQUENCY
        ELSE IF (N.EQ.12) THEN
          CALL DECOFF(TOKEN,IRAD)

*** TITLES
        ELSE IF (N.EQ.13) THEN
          N=KEYUPC(TOKEN,OFFTAB,1)
          IF (N.EQ.1) THEN
            TITLES=.FALSE.
          ELSE
            CALL RQUOTE(TOKEN,TSTR,NC)
            TITLES=.TRUE.
          END IF

*** DEVICE_OPTIONS
        ELSE IF (N.EQ.14) THEN
          CALL RQUOTE(TOKEN,DEVOPT,NC)

*** PLOT_OPTIONS
        ELSE IF (N.EQ.15) THEN
          CALL RQUOTE(TOKEN,PLTOPT,NC)

*** LABELS
        ELSE IF (N.EQ.16) THEN
          CALL DECOFF(TOKEN,IT)
          LABELS=IT.NE.0

***
        END IF

        GO TO 300
      END IF
      GO TO 200

* Error checks
 600  IF (IPLOT.EQ.IMPLR) THEN
        IF (ILOG.EQ.LOGS)
     -    CALL WARN('PFGETP - Log frequency option '//
     -              'incompatible with impulse response')
        IF (IRAD.EQ.RFREQ)
     -    CALL WARN('PFGETP - Radian frequency option '//
     -              'incompatible with impulse response')
      END IF

* Convert radian limits to Hz
      IF (XSPEC .AND. IRAD.EQ.RFREQ) THEN
        XMIN=0.5*XMIN
        XMAX=0.5*XMAX
      END IF

* Return the frequency axis option
      IFAXIS=ILOG+2*IRAD


      RETURN

      END
