*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE PSYERR (STRING)
*
*
* Purpose:
*     Print a system error message and stop
*
*
* Description:
*     This routine prints a system error message.  The system error
*     message is printed using PERROR.  The preamble string is obtained
*     from the command name portion of the command line.  After
*     printing the system error message, the input string is printed
*     on the standard error unit (unit 0), and execution is terminated
*     by invoking EXIT(255).
*
*
* Parameters:
* C ->  STRING - Message string
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:44:12 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE PSYERR (STRING)


      INTEGER NC

      CHARACTER*(*) STRING
      CHARACTER*255 IMAGNM


* Get the name of the command used to invoke the program
      CALL GETIMG(IMAGNM,NC)

* Print the system error message
      CALL PERROR(IMAGNM(1:NC))
      CALL HALT(STRING)


      RETURN

      END
