*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE GETUSR (USERNM, NC)
*
*
* Purpose:
*     Get the user name
*
*
* Description:
*     This routine returns a string containing the host machine and
*     user name in the form "user@host".  The host name may be a simple
*     name or the fully qualified internet name, depending on the
*     string returned by the system function HOSTNM.
*
*
* Parameters:
* C <-  USERNM - Output string
* I <-  NC     - Number of characters set in USERNM
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.6 $  $Date: 1995/03/08 15:44:01 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE GETUSR (USERNM, NC)


      INTEGER NC
      INTEGER ISTAT,NCH,NCU
      INTEGER LENBLK

      CHARACTER*(*) USERNM
      CHARACTER*40 USER
      CHARACTER*256 HOST

      INTEGER HOSTNM


* Get the host name
      ISTAT=HOSTNM(HOST)
      IF (ISTAT.NE.0)
     -  CALL PSYERR('GETUSR - System error return from HOSTNM')
      NCH=LENBLK(HOST)

* Get the user name
* First try the environment variable USER, then the GETLOG system function,
* and then the environment variable LOGNAME
      CALL GETENV('USER',USER)
      NCU=LENBLK(USER)
      IF (NCU.EQ.0) THEN
        CALL GETLOG(USER)
        NCU=LENBLK(USER)
        IF (NCU.EQ.0) THEN
          CALL GETENV('LOGNAME',USER)
          NCU=LENBLK(USER)
        END IF
      END IF

* Copy the host and user names to the output string
      USERNM=USER(1:NCU)//'@'//HOST(1:NCH)
      NC=NCH+NCU+1
      IF (NC.GT.LEN(USERNM)) THEN
        CALL WARN('GETUSR - Output string truncated')
        NC=LEN(USERNM)
      END IF


      RETURN

      END
