*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE GETIMG (IMAGNM, NC)
*
*
* Purpose:
*     Get the image name
*
*
* Description:
*     This routine returns a string containing the name of the image
*     running.  This is determined from the command line by stripping
*     off the path name information from the first part of the command
*     line.
*
*
* Parameters:
* C <-  IMAGNM - Output string
* I <-  NC     - Number of characters set in IMAGNM
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:43:58 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE GETIMG (IMAGNM, NC)


      INTEGER NC
      INTEGER IE,IS
      INTEGER LENSTR,INDEXR

      CHARACTER*(*) IMAGNM
      CHARACTER*255 COMD


* Get the image name, omitting the path name
      CALL GETARG(0,COMD)
      IE=LENSTR(COMD)
      IS=INDEXR(COMD,'/')+1
      IE=MAX(IS,IE)

      IMAGNM=COMD(IS:IE)
      NC=IE-IS+1


      RETURN

      END
