*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE GETDAT (DATTIM)
*
*
* Purpose:
*     Get the date and time as a string
*
*
* Description:
*     This routine returns a string containing the date and time. The
*     format of the returned string depends on the length of the
*     string.
*       24 characters or more:
*         Sun May 11 13:55:45 1988
*       20-23 characters:
*         May 11 13:55:45 1988
*       17-19 characters:
*         May 11 13:55 1988
*       11-18 characters:
*         May 11 1988
*
*
* Parameters:
* C <-  DATTIM - Output character string containing the date and time.
*                The full length string is 24 characters long.
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.5 $  $Date: 1995/03/08 15:43:55 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE GETDAT (DATTIM)


      INTEGER LEND

      CHARACTER*(*) DATTIM
      CHARACTER*24 STIME


* Get the date and time
      CALL FDATE(STIME)

* Selectively leave out parts of the date/time
      LEND=LEN(DATTIM)
      IF (LEND.GE.24) THEN
        DATTIM=STIME
      ELSE IF (LEND.GE.20) THEN
        DATTIM=STIME(5:)
      ELSE IF (LEND.GE.17) THEN
        DATTIM=STIME(5:16)//STIME(20:)
      ELSE IF (LEND.GE.11) THEN
        DATTIM=STIME(5:10)//STIME(20:)
      ELSE
        DATTIM=STIME(5:10)//STIME(20:)
        CALL WARN('GETDAT - Output string truncated')
      END IF


      RETURN

      END
