*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE UPCSTR (STRIN, STROUT)
*
*
* Purpose:
*     Convert a string to uppercase
*
*
* Description:
*     This routine copies the input string to the output string,
*     converting to uppercase in the process.  This routine also
*     handles accented characters in the ISO Latin-1 alphabet,
*     converting them to their uppercase equivalents.
*
*
* Parameters:
* C ->  STRIN  - Input string
* C <-  STROUT - Output string.  This may be the same string as STRIN.
*                STROUT is padded out with blanks if necessary.
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:38:23 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE UPCSTR (STRIN, STROUT)


      INTEGER LENI,LENO,I,IC

      CHARACTER*(*) STRIN,STROUT

* Table of ASCII codes, codes for a-z are changed to the codes for
* A-Z.  In addition, the codes for lowercase accented letters in the
* ISO Latin-1 multinational character set are changed to the codes
* for the corresponding uppercase accented letters.
      INTEGER UCTAB(0:255)
      DATA (UCTAB(I),I=0,49)
     -          /  0,  1,  2,  3,  4,  5,  6,  7,  8,  9,
     -            10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
     -            20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
     -            30, 31, 32, 33, 34, 35, 36, 37, 38, 39,
     -            40, 41, 42, 43, 44, 45, 46, 47, 48, 49/
      DATA (UCTAB(I),I=50,99)
     -          / 50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
     -            60, 61, 62, 63, 64, 65, 66, 67, 68, 69,
     -            70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
     -            80, 81, 82, 83, 84, 85, 86, 87, 88, 89,
     -            90, 91, 92, 93, 94, 95, 96, 65, 66, 67/
      DATA (UCTAB(I),I=100,149)
     -          / 68, 69, 70, 71, 72, 73, 74, 75, 76, 77,
     -            78, 79, 80, 81, 82, 83, 84, 85, 86, 87,
     -            88, 89, 90,123,124,125,126,127,128,129,
     -           130,131,132,133,134,135,136,137,138,139,
     -           140,141,142,143,144,145,146,147,148,149/
      DATA (UCTAB(I),I=150,199)
     -          /150,151,152,153,154,155,156,157,158,159,
     -           160,161,162,163,164,165,166,167,168,169,
     -           170,171,172,173,174,175,176,177,178,179,
     -           180,181,182,183,184,185,186,187,188,189,
     -           190,191,192,193,194,195,196,197,198,199/
      DATA (UCTAB(I),I=200,249)
     -          /200,201,202,203,204,205,206,207,208,209,
     -           210,211,212,213,214,215,216,217,218,219,
     -           220,221,222,223,192,193,194,195,196,197,
     -           198,199,200,201,202,203,204,205,206,207,
     -           208,209,210,211,212,213,214,247,216,217/
      DATA (UCTAB(I),I=250,255)
     -          /218,219,220,221,222,255/


      LENI=LEN(STRIN)
      LENO=LEN(STROUT)

* Convert to uppercase
      DO 100 I=1,MIN(LENI,LENO)
        IC=ICHAR(STRIN(I:I))
        IF (IC.LT.0) IC=IC+256
        STROUT(I:I)=CHAR(UCTAB(IC))
 100  CONTINUE

* Check for string truncation
      IF (LENI.LT.LENO) THEN
        STROUT(LENI+1:)=' '
      ELSE IF (LENI.GT.LENO) THEN
        CALL HALT('UPCSTR - String truncated')
      END IF


      RETURN

      END
