*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE UPCASE (STRIN, STROUT)
*
*
* Purpose:
*     Convert a string to uppercase (trim and obey quotes)
*
*
* Description:
*     This routine copies the input string to the output string,
*     removing leading blanks, tabs and nulls and converting to
*     uppercase in the process.  Characters within paired double quotes
*     (") are not converted to uppercase.  Blanks, tabs and null within
*     paired double quotes are not removed.  This routine also handles
*     accented characters in the ISO Latin-1 alphabet, converting them
*     to their uppercase equivalents.
*
*
* Parameters:
* C ->  STRIN  - Input string
* C <-  STROUT - Output string.  This may be the same string as STRIN.
*                STROUT is padded out with blanks if necessary.
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:38:20 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE UPCASE (STRIN, STROUT)


      INTEGER IE,IS,NCI,LENO,N,I
      INTEGER LENSTR,LOCNBL

      CHARACTER*(*) STRIN,STROUT
      CHARACTER*1 CH

      LOGICAL INQUOT


* Find the first and last significant character
      IE=LENSTR(STRIN)
      IS=LOCNBL(STRIN(1:IE))
      NCI=IE-IS+1
      LENO=LEN(STROUT)

* Copy the string and convert to uppercase
      INQUOT=.FALSE.
      N=IS
      DO 100 I=1,MIN(NCI,LENO)
        CH=STRIN(N:N)
        N=N+1
        IF (CH.EQ.'"') THEN
          INQUOT=.NOT.INQUOT
          STROUT(I:I)=CH
        ELSE IF (.NOT.INQUOT) THEN
          CALL UPCSTR(CH,STROUT(I:I))
        ELSE
          STROUT(I:I)=CH
        END IF
 100  CONTINUE

* Check for string truncation
      IF (NCI.LT.LENO) THEN
        STROUT(NCI+1:)=' '
      ELSE IF (NCI.GT.LENO) THEN
        CALL HALT('UPCASE - String truncated')
      END IF


      RETURN

      END
