*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE STTRIM (STRIN, STROUT, NC)
*
*
* Purpose:
*     Trim leading and trailing white space from a string
*
*
* Description:
*     This routine copies an input string omitting leading and trailing
*     white space (blank, tab or null characters).
*
*
* Parameters:
* C ->  STRIN  - Input string
* C <-  STROUT - Output string
* I <-  NC     - Number of characters in the output string
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:38:17 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE STTRIM (STRIN, STROUT, NC)


      CHARACTER*(*) STRIN,STROUT

      INTEGER NC,IST,IFN,LOCNBL,LENSTR


      IFN=LENSTR(STRIN)
      IF (IFN.GT.0) THEN
        IST=LOCNBL(STRIN(1:IFN))
        CALL STCOPY(STRIN(IST:IFN),STROUT,NC)
      ELSE
        STROUT=' '
        NC=0
      END IF


      RETURN

      END
